/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import javax.validation.ValidationException;
import org.apache.bval.util.PrivilegedActions;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureActions
extends PrivilegedActions {
    public static <T> T newInstance(Class<T> cls) {
        return (T)SecureActions.newInstance(cls, ValidationException.class);
    }

    public static <T> T newInstance(Class<T> cls, Class<?>[] paramTypes, Object[] values) {
        return (T)SecureActions.newInstance(cls, ValidationException.class, (Class[])paramTypes, (Object[])values);
    }

    public static Class<?> loadClass(final String className, final Class<?> caller) {
        return (Class)SecureActions.run((PrivilegedAction)new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    if (contextClassLoader != null) {
                        return contextClassLoader.loadClass(className);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    return Class.forName(className, true, caller.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Unable to load class: " + className, (Throwable)e);
                }
            }
        });
    }

    public static Field getDeclaredField(final Class<?> clazz, final String fieldName) {
        return (Field)SecureActions.run((PrivilegedAction)new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field f = clazz.getDeclaredField(fieldName);
                    SecureActions.setAccessibility(f);
                    return f;
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            }
        });
    }

    private static void setAccessibility(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || Modifier.isPublic(field.getModifiers()) && Modifier.isAbstract(field.getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static Method getGetter(final Class<?> clazz, final String methodName) {
        return (Method)SecureActions.run((PrivilegedAction)new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    String methodName0 = StringUtils.capitalize((String)methodName);
                    try {
                        return clazz.getMethod("get" + methodName0, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        return clazz.getMethod("is" + methodName0, new Class[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }

    public static Method getMethod(final Class<?> clazz, final String methodName) {
        return (Method)SecureActions.run((PrivilegedAction)new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }

    public static Method[] getDeclaredMethods(final Class<?> clazz) {
        return (Method[])SecureActions.run((PrivilegedAction)new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    public static <T> Constructor<T> getConstructor(final Class<T> clazz, final Class<?> ... params) {
        return (Constructor)SecureActions.run((PrivilegedAction)new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    return clazz.getConstructor(params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }
}

