/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.extensions;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Valid;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.AppendValidation;
import org.apache.bval.jsr303.Jsr303MetaBeanFactory;
import org.apache.bval.jsr303.extensions.AppendValidationToList;
import org.apache.bval.jsr303.extensions.ConstructorDescriptorImpl;
import org.apache.bval.jsr303.extensions.MethodBeanDescriptorImpl;
import org.apache.bval.jsr303.extensions.MethodDescriptor;
import org.apache.bval.jsr303.extensions.MethodDescriptorImpl;
import org.apache.bval.jsr303.extensions.ParameterAccess;
import org.apache.bval.jsr303.extensions.ParameterDescriptorImpl;
import org.apache.bval.jsr303.extensions.ProcedureDescriptor;
import org.apache.bval.jsr303.extensions.ReturnAccess;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.model.Validation;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodValidatorMetaBeanFactory
extends Jsr303MetaBeanFactory {
    public MethodValidatorMetaBeanFactory(ApacheFactoryContext factoryContext) {
        super(factoryContext);
    }

    @Override
    protected boolean hasValidationConstraintsDefined(Method method) {
        return false;
    }

    public void buildMethodDescriptor(MethodBeanDescriptorImpl descriptor) {
        try {
            this.buildMethodConstraints(descriptor);
            this.buildConstructorConstraints(descriptor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void buildConstructorConstraints(MethodBeanDescriptorImpl beanDesc) throws InvocationTargetException, IllegalAccessException {
        beanDesc.setConstructorConstraints(new HashMap());
        for (Constructor<?> cons : beanDesc.getMetaBean().getBeanClass().getDeclaredConstructors()) {
            if (this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(cons)) continue;
            ConstructorDescriptorImpl consDesc = new ConstructorDescriptorImpl(beanDesc.getMetaBean(), new Validation[0]);
            beanDesc.putConstructorDescriptor(cons, consDesc);
            Annotation[][] paramsAnnos = cons.getParameterAnnotations();
            int idx = 0;
            for (Annotation[] paramAnnos : paramsAnnos) {
                ParameterAccess access = new ParameterAccess(cons.getParameterTypes()[idx], idx);
                this.processAnnotations(consDesc, paramAnnos, access, idx);
                ++idx;
            }
        }
    }

    private void buildMethodConstraints(MethodBeanDescriptorImpl beanDesc) throws InvocationTargetException, IllegalAccessException {
        beanDesc.setMethodConstraints(new HashMap<Method, MethodDescriptor>());
        for (Method method : beanDesc.getMetaBean().getBeanClass().getDeclaredMethods()) {
            if (this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(method)) continue;
            MethodDescriptorImpl methodDesc = new MethodDescriptorImpl(beanDesc.getMetaBean(), new Validation[0]);
            beanDesc.putMethodDescriptor(method, methodDesc);
            AppendValidationToList validations = new AppendValidationToList();
            ReturnAccess returnAccess = new ReturnAccess(method.getReturnType());
            for (Annotation anno : method.getAnnotations()) {
                if (anno instanceof Valid) {
                    methodDesc.setCascaded(true);
                    continue;
                }
                this.processAnnotation(anno, methodDesc, returnAccess, validations);
            }
            methodDesc.getConstraintDescriptors().addAll(validations.getValidations());
            Annotation[][] paramsAnnos = method.getParameterAnnotations();
            int idx = 0;
            for (Annotation[] paramAnnos : paramsAnnos) {
                ParameterAccess access = new ParameterAccess(method.getParameterTypes()[idx], idx);
                this.processAnnotations(methodDesc, paramAnnos, access, idx);
                ++idx;
            }
        }
    }

    private void processAnnotations(ProcedureDescriptor methodDesc, Annotation[] paramAnnos, AccessStrategy access, int idx) throws InvocationTargetException, IllegalAccessException {
        AppendValidationToList validations = new AppendValidationToList();
        boolean cascaded = false;
        for (Annotation anno : paramAnnos) {
            if (anno instanceof Valid) {
                cascaded = true;
                continue;
            }
            this.processAnnotation(anno, methodDesc, access, validations);
        }
        ParameterDescriptorImpl paramDesc = new ParameterDescriptorImpl(methodDesc.getMetaBean(), validations.getValidations().toArray(new Validation[validations.getValidations().size()]));
        paramDesc.setIndex(idx);
        paramDesc.setCascaded(cascaded);
        methodDesc.getParameterDescriptors().add(paramDesc);
    }

    private <A extends Annotation> void processAnnotation(A annotation, ProcedureDescriptor desc, AccessStrategy access, AppendValidation validations) throws InvocationTargetException, IllegalAccessException {
        if (annotation instanceof Valid) {
            desc.setCascaded(true);
        } else {
            Constraint vcAnno = annotation.annotationType().getAnnotation(Constraint.class);
            if (vcAnno != null) {
                Class<ConstraintValidator<A, ?>>[] validatorClasses = this.findConstraintValidatorClasses(annotation, vcAnno);
                this.applyConstraint(annotation, validatorClasses, null, ClassUtils.primitiveToWrapper((Class)((Class)access.getJavaType())), access, validations);
            } else {
                Object result = SecureActions.getAnnotationValue(annotation, (String)"value");
                if (result != null && result instanceof Annotation[]) {
                    for (Annotation each : (Annotation[])result) {
                        this.processAnnotation(each, desc, access, validations);
                    }
                }
            }
        }
    }
}

