/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.util.HashMap;
import java.util.Map;
import org.apache.bval.IntrospectorMetaBeanFactory;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.model.MetaBean;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBeanBuilder {
    private static final Log log = LogFactory.getLog(MetaBeanBuilder.class);
    private MetaBeanFactory[] factories;

    public MetaBeanBuilder() {
        this(new MetaBeanFactory[]{new IntrospectorMetaBeanFactory()});
    }

    public MetaBeanBuilder(MetaBeanFactory[] factories) {
        this.setFactories(factories);
    }

    public MetaBeanFactory[] getFactories() {
        return this.factories;
    }

    public void setFactories(MetaBeanFactory[] factories) {
        this.factories = factories;
    }

    public MetaBean buildForId(String beanInfoId) throws Exception {
        throw new IllegalArgumentException("MetaBean " + beanInfoId + " not found");
    }

    public Map<String, MetaBean> buildAll() throws Exception {
        return new HashMap<String, MetaBean>();
    }

    protected Class<?> findLocalClass(String className) {
        if (className != null) {
            try {
                return ClassUtils.getClass((String)className);
            }
            catch (ClassNotFoundException e) {
                log.trace((Object)("class not found: " + className), (Throwable)e);
            }
        }
        return null;
    }

    public MetaBean buildForClass(Class<?> clazz) throws Exception {
        MetaBean meta = new MetaBean();
        if (clazz != null) {
            meta.setBeanClass(clazz);
            meta.setId(clazz.getName());
        }
        for (MetaBeanFactory factory : this.factories) {
            factory.buildMetaBean(meta);
        }
        return meta;
    }
}

