/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public class PrimitiveDataType
extends DataType {
    private static final Log log = LogFactory.getLog(PrimitiveDataType.class);
    private static Map PRIMITIVE_TYPES = new HashMap();

    public static TypeCode getTypeCode(String typeName) {
        TypeCode typeCode = (TypeCode)PRIMITIVE_TYPES.get(typeName);
        if (typeCode == null && typeName != null && typeName.contains("::")) {
            String typeName2 = typeName.substring(0, typeName.indexOf("::"));
            typeCode = (TypeCode)PRIMITIVE_TYPES.get(typeName2);
            return typeCode;
        }
        return typeCode;
    }

    public static boolean isPrimitive(TypeCode typeCode) {
        return typeCode != null && PRIMITIVE_TYPES.values().contains(typeCode);
    }

    public static PrimitiveDataType getPrimitiveDataType(String typeName) {
        TypeCode typeCode = PrimitiveDataType.getTypeCode(typeName);
        if (typeCode == null) {
            return null;
        }
        return new PrimitiveDataType(typeCode);
    }

    public PrimitiveDataType(TypeCode typeCode) {
        this.typeCode = typeCode;
    }

    protected TypeCode generateTypeCode() {
        return this.typeCode;
    }

    public String getTypeName() {
        TCKind kind;
        String ret = null;
        if (this.typeCode != null && (kind = this.typeCode.kind()) != null) {
            switch (kind.value()) {
                case 3: {
                    ret = "int";
                    break;
                }
                case 5: {
                    ret = "int";
                    break;
                }
                case 23: {
                    ret = "long";
                    break;
                }
                case 24: {
                    ret = "long";
                    break;
                }
                case 2: {
                    ret = "short";
                    break;
                }
                case 4: {
                    ret = "short";
                    break;
                }
                case 6: {
                    ret = "float";
                    break;
                }
                case 7: {
                    ret = "double";
                    break;
                }
                case 9: {
                    ret = "char";
                    break;
                }
                case 26: {
                    ret = "char";
                    break;
                }
                case 8: {
                    ret = "boolean";
                    break;
                }
                case 10: {
                    ret = "byte";
                    break;
                }
                case 18: {
                    ret = "java.lang.String";
                    break;
                }
                case 27: {
                    ret = "java.lang.String";
                    break;
                }
                case 1: {
                    ret = "void";
                    break;
                }
                default: {
                    log.error((Object)"Invalid primitive data type");
                }
            }
        }
        return ret;
    }

    static {
        ORB orb = ORB.init();
        PRIMITIVE_TYPES.put("long", orb.get_primitive_tc(TCKind.tk_long));
        PRIMITIVE_TYPES.put("ulong", orb.get_primitive_tc(TCKind.tk_ulong));
        PRIMITIVE_TYPES.put("longlong", orb.get_primitive_tc(TCKind.tk_longlong));
        PRIMITIVE_TYPES.put("ulonglong", orb.get_primitive_tc(TCKind.tk_ulonglong));
        PRIMITIVE_TYPES.put("short", orb.get_primitive_tc(TCKind.tk_short));
        PRIMITIVE_TYPES.put("ushort", orb.get_primitive_tc(TCKind.tk_ushort));
        PRIMITIVE_TYPES.put("float", orb.get_primitive_tc(TCKind.tk_float));
        PRIMITIVE_TYPES.put("double", orb.get_primitive_tc(TCKind.tk_double));
        PRIMITIVE_TYPES.put("char", orb.get_primitive_tc(TCKind.tk_char));
        PRIMITIVE_TYPES.put("wchar", orb.get_primitive_tc(TCKind.tk_wchar));
        PRIMITIVE_TYPES.put("boolean", orb.get_primitive_tc(TCKind.tk_boolean));
        PRIMITIVE_TYPES.put("octet", orb.get_primitive_tc(TCKind.tk_octet));
        PRIMITIVE_TYPES.put("string", orb.get_primitive_tc(TCKind.tk_string));
        PRIMITIVE_TYPES.put("wstring", orb.get_primitive_tc(TCKind.tk_wstring));
        PRIMITIVE_TYPES.put("any", orb.get_primitive_tc(TCKind.tk_any));
        PRIMITIVE_TYPES.put("longdouble", orb.get_primitive_tc(TCKind.tk_longdouble));
        PRIMITIVE_TYPES.put("void", orb.get_primitive_tc(TCKind.tk_void));
    }
}

