/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.container.AbstractServiceReferenceRecipe;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.di.CollectionRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.container.ServiceUnavailableException;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceRecipe
extends AbstractServiceReferenceRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceRecipe.class);
    private final ReferenceMetadata metadata;
    private Object proxy;
    private volatile ServiceReference trackedServiceReference;
    private volatile Object trackedService;
    private final Object monitor = new Object();

    public ReferenceRecipe(String name, ExtendedBlueprintContainer blueprintContainer, ReferenceMetadata metadata, CollectionRecipe listenersRecipe, List<Recipe> explicitDependencies) {
        super(name, blueprintContainer, metadata, listenersRecipe, explicitDependencies);
        this.metadata = metadata;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        try {
            if (this.explicitDependencies != null) {
                for (Recipe recipe : this.explicitDependencies) {
                    recipe.create();
                }
            }
            HashSet interfaces = new HashSet();
            Class clz = this.getInterfaceClass();
            if (clz != null) {
                interfaces.add(clz);
            }
            this.proxy = this.createProxy(new ServiceDispatcher(), interfaces);
            ServiceProxyWrapper wrapper = new ServiceProxyWrapper();
            this.addPartialObject(wrapper);
            this.createListeners();
            this.updateListeners();
            return wrapper;
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ComponentDefinitionException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Object object = this.monitor;
        synchronized (object) {
            this.unbind();
            this.monitor.notifyAll();
        }
    }

    @Override
    protected void retrack() {
        ServiceReference ref = this.getBestServiceReference();
        if (ref != null) {
            this.bind(ref);
        } else {
            this.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void track(ServiceReference ref) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.trackedServiceReference == null) {
                this.retrack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void untrack(ServiceReference ref) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.trackedServiceReference == ref) {
                this.retrack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(ServiceReference ref) {
        LOGGER.debug("Binding reference {} to {}", (Object)this.getName(), (Object)ref);
        Object object = this.monitor;
        synchronized (object) {
            if (this.trackedServiceReference != null) {
                this.blueprintContainer.getBundleContext().ungetService(this.trackedServiceReference);
            }
            this.trackedServiceReference = ref;
            this.trackedService = null;
            this.monitor.notifyAll();
            this.bind(this.trackedServiceReference, this.proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        LOGGER.debug("Unbinding reference {}", (Object)this.getName());
        Object object = this.monitor;
        synchronized (object) {
            if (this.trackedServiceReference != null) {
                this.unbind(this.trackedServiceReference, this.proxy);
                this.blueprintContainer.getBundleContext().ungetService(this.trackedServiceReference);
                this.trackedServiceReference = null;
                this.trackedService = null;
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getService() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isStarted() && this.trackedServiceReference == null && this.metadata.getTimeout() > 0L && this.metadata.getAvailability() == 1) {
                this.blueprintContainer.getEventDispatcher().blueprintEvent(new BlueprintEvent(7, this.blueprintContainer.getBundleContext().getBundle(), this.blueprintContainer.getExtenderBundle(), new String[]{this.getOsgiFilter()}));
                this.monitor.wait(this.metadata.getTimeout());
            }
            if (this.trackedServiceReference == null) {
                if (this.isStarted()) {
                    if (this.metadata.getAvailability() == 1) {
                        LOGGER.info("Timeout expired when waiting for mandatory OSGi service reference {}", (Object)this.getOsgiFilter());
                        throw new ServiceUnavailableException("Timeout expired when waiting for mandatory OSGi service reference: " + this.getOsgiFilter(), this.getOsgiFilter());
                    }
                    LOGGER.info("No matching service for optional OSGi service reference {}", (Object)this.getOsgiFilter());
                    throw new ServiceUnavailableException("No matching service for optional OSGi service reference: " + this.getOsgiFilter(), this.getOsgiFilter());
                }
                throw new ServiceUnavailableException("The Blueprint container is being or has been destroyed: " + this.getOsgiFilter(), this.getOsgiFilter());
            }
            if (this.trackedService == null) {
                this.trackedService = this.blueprintContainer.getService(this.trackedServiceReference);
            }
            if (this.trackedService == null) {
                throw new IllegalStateException("getService() returned null for " + this.trackedServiceReference);
            }
            return this.trackedService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference getServiceReference() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.optional) {
                this.getService();
            }
            return this.trackedServiceReference;
        }
    }

    public class ServiceProxyWrapper
    implements AggregateConverter.Convertible {
        public Object convert(ReifiedType type) throws Exception {
            if (type.getRawClass() == ServiceReference.class) {
                return ReferenceRecipe.this.getServiceReference();
            }
            if (type.getRawClass().isInstance(ReferenceRecipe.this.proxy)) {
                return ReferenceRecipe.this.proxy;
            }
            throw new ComponentDefinitionException("Unable to convert to " + type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServiceDispatcher
    implements Callable<Object> {
        @Override
        public Object call() throws Exception {
            return ReferenceRecipe.this.getService();
        }
    }
}

