/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.client;

import java.util.HashMap;
import org.apache.amber.oauth2.client.HttpClient;
import org.apache.amber.oauth2.client.request.OAuthClientRequest;
import org.apache.amber.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.amber.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.exception.OAuthSystemException;

public class OAuthClient {
    protected HttpClient httpClient;

    public OAuthClient(HttpClient oauthClient) {
        this.httpClient = oauthClient;
    }

    public <T extends OAuthAccessTokenResponse> T accessToken(OAuthClientRequest request, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, "POST", responseClass);
    }

    public <T extends OAuthAccessTokenResponse> T accessToken(OAuthClientRequest request, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return (T)((OAuthAccessTokenResponse)this.httpClient.execute(request, headers, requestMethod, responseClass));
    }

    public OAuthJSONAccessTokenResponse accessToken(OAuthClientRequest request) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, OAuthJSONAccessTokenResponse.class);
    }

    public OAuthJSONAccessTokenResponse accessToken(OAuthClientRequest request, String requestMethod) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, requestMethod, OAuthJSONAccessTokenResponse.class);
    }

    public void shutdown() {
        this.httpClient.shutdown();
    }
}

