/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.commons.config;

import java.util.Properties;

public class ConfigurationManager {
    protected Properties configurations = new Properties();

    public ConfigurationManager(String configFileName) {
        try {
            this.configurations.load(this.getClass().getClassLoader().getResourceAsStream(configFileName));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to load configurations:::" + configFileName, e);
        }
    }

    public String getConfig(String configName) {
        return this.configurations.getProperty(configName);
    }

    public String getConfig(String configName, String defaultVal) {
        return this.configurations.getProperty(configName, defaultVal);
    }

    public int getConfig(String configName, int defaultVal) {
        return Integer.parseInt(this.configurations.getProperty(configName, Integer.toString(defaultVal)));
    }

    public long getConfig(String configName, long defaultVal) {
        return Long.parseLong(this.configurations.getProperty(configName, Long.toString(defaultVal)));
    }
}

