/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.commons;

public class WsmgVersion {
    public static final String SPEC_VERSION = "1.0.0";
    private static final String BUILD = "";
    private static final String PROJECT_NAME = "WSMG";
    private static final String IMPL_VERSION = "1.0.0";
    private static final String USER_AGENT = "WSMG/1.0.0";
    private static int VERSION_MAJOR = -1;
    private static int VERSION_MINOR = -1;
    private static int VERSION_INCREMENT = -1;

    public static String getUserAgent() {
        return USER_AGENT;
    }

    public static String getVersion() {
        return "1.0.0";
    }

    public static String getSpecVersion() {
        return "1.0.0";
    }

    public static String getImplementationVersion() {
        return "1.0.0";
    }

    public static void main(String[] args) {
        String SPEC_OPT = "-spec";
        String IMPL_OPT = "-impl";
        if (SPEC_OPT.equals(args[0])) {
            System.out.println("1.0.0");
        } else if (IMPL_OPT.equals(args[0])) {
            System.out.println("1.0.0");
        } else {
            System.err.println(WsmgVersion.class.getName() + " Error: " + SPEC_OPT + " or " + IMPL_OPT + " is required");
            System.exit(1);
        }
    }

    public static void requireVersionOrExit(String version) {
        try {
            WsmgVersion.requireVersion(version);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Error: could not find required version " + version + " of " + PROJECT_NAME + ": " + ex.getMessage());
            System.err.println("Please make sure that JAR file with WSMG with version " + version + " (or higher) is available.");
            System.err.println("Please make sure there is no more than one JAR file with WSMG");
            System.err.println("Exiting");
            System.exit(1);
        }
    }

    public static void requireVersion(String version) throws IllegalStateException {
        int[] parsed;
        if (VERSION_MAJOR < 0) {
            WsmgVersion.extractCurrentVersion();
        }
        try {
            parsed = WsmgVersion.parseVersion(version);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("could not parse WSMG version string " + version);
        }
        int major = parsed[0];
        int minor = parsed[1];
        int increment = parsed[2];
        if (major != VERSION_MAJOR) {
            throw new IllegalStateException("required WSMG " + version + " has different major version" + " from current " + "1.0.0");
        }
        if (minor > VERSION_MINOR) {
            throw new IllegalStateException("required WSMG " + version + " has too big minor version" + " when compared to current " + "1.0.0");
        }
        if (minor == VERSION_MINOR && increment > VERSION_INCREMENT) {
            throw new IllegalStateException("required WSMG " + version + " has too big increment version" + " when compared to current " + "1.0.0");
        }
    }

    public static int[] parseVersion(String version) throws NumberFormatException {
        int[] parsed = new int[3];
        int firstDot = version.indexOf(46);
        if (firstDot == -1) {
            throw new NumberFormatException("expected version string N.M but there is no dot in " + version);
        }
        String majorVersion = version.substring(0, firstDot);
        parsed[0] = Integer.parseInt(majorVersion);
        if (parsed[0] < 0) {
            throw new NumberFormatException("major N version number in N.M can not be negative in " + version);
        }
        int secondDot = version.indexOf(46, firstDot + 1);
        String minorVersion = secondDot >= 0 ? version.substring(firstDot + 1, secondDot) : version.substring(firstDot + 1);
        parsed[1] = Integer.parseInt(minorVersion);
        if (parsed[1] < 0) {
            throw new NumberFormatException("minor M version number in N.M can not be negative in " + version);
        }
        if (secondDot >= 0) {
            String incrementVersion = version.substring(secondDot + 1);
            parsed[2] = Integer.parseInt(incrementVersion);
            if (parsed[2] < 0) {
                throw new NumberFormatException("increment K version number in N.M.K must be positive number in " + version);
            }
        }
        return parsed;
    }

    private static synchronized void extractCurrentVersion() throws IllegalStateException {
        int[] parsed;
        try {
            parsed = WsmgVersion.parseVersion("1.0.0");
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("internal problem: could not parse current WSMG version string 1.0.0");
        }
        VERSION_MAJOR = parsed[0];
        VERSION_MINOR = parsed[1];
        VERSION_INCREMENT = parsed[2];
    }
}

