/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox;

import java.util.List;
import org.apache.airavata.wsmg.commons.MsgBoxQNameConstants;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.dispatchers.AddressingBasedDispatcher;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageHandler
extends AddressingBasedDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(StoreMessageHandler.class);
    private static final String WSMG_MSGSTORE_SOAP_ACTION = MsgBoxQNameConstants.STOREMSG_QNAME.getNamespaceURI() + MsgBoxQNameConstants.STOREMSG_QNAME.getLocalPart();
    private static final String ADDRESSING_VALIDATE_ACTION = "addressing.validateAction";
    private Phase addressingPhase;
    private AxisOperation messageBoxOperation;

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
        if (msgContext.getAxisService() == null || msgContext.getAxisOperation() == null) {
            boolean validateAction = JavaUtils.isTrue((Object)msgContext.getProperty(ADDRESSING_VALIDATE_ACTION), (boolean)true);
            msgContext.setProperty(ADDRESSING_VALIDATE_ACTION, (Object)false);
            response = super.invoke(msgContext);
            if (this.isForMessageBoxService(msgContext)) {
                this.validateMsgBoxStoreOperation(msgContext);
            }
            if (validateAction) {
                this.checkAction(msgContext);
            }
            msgContext.setProperty(ADDRESSING_VALIDATE_ACTION, (Object)validateAction);
        }
        return response;
    }

    private void validateMsgBoxStoreOperation(MessageContext msgContext) {
        if (msgContext.getAxisOperation() == null) {
            AxisService service = msgContext.getAxisService();
            AxisOperation storeMsgOperation = this.getMessageBoxOperation(service);
            msgContext.setAxisOperation(storeMsgOperation);
        }
    }

    private boolean isForMessageBoxService(MessageContext msgContext) {
        return msgContext.getAxisService() != null && msgContext.getAxisService().getName().equals("MsgBoxService");
    }

    private AxisOperation getMessageBoxOperation(AxisService msgBoxService) {
        if (this.messageBoxOperation == null) {
            this.messageBoxOperation = msgBoxService.getOperationBySOAPAction(WSMG_MSGSTORE_SOAP_ACTION);
        }
        return this.messageBoxOperation;
    }

    private void checkAction(MessageContext msgContext) throws AxisFault {
        Phase addPhase = this.getAddressingPhase(msgContext);
        if (addPhase == null) {
            logger.error("unable to locate addressing phase object");
        }
        if (msgContext != null && msgContext.getCurrentPhaseIndex() + 1 == addPhase.getHandlerCount() && (msgContext.getAxisService() == null || msgContext.getAxisOperation() == null)) {
            AddressingFaultsHelper.triggerActionNotSupportedFault((MessageContext)msgContext, (String)msgContext.getWSAAction());
        }
    }

    private Phase getAddressingPhase(MessageContext context) {
        if (this.addressingPhase == null) {
            List inFlowPhases = context.getConfigurationContext().getAxisConfiguration().getPhasesInfo().getINPhases();
            for (Phase p : inFlowPhases) {
                if (!p.getName().equalsIgnoreCase("Addressing")) continue;
                this.addressingPhase = p;
            }
        }
        return this.addressingPhase;
    }
}

