/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox.Storage.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.airavata.wsmg.msgbox.Storage.MsgBoxStorage;
import org.apache.axiom.om.OMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryImpl
implements MsgBoxStorage {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryImpl.class);
    private HashMap<String, List<Content>> map = new HashMap();
    private long time;

    public InMemoryImpl(long time) {
        this.time = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createMsgBox() throws Exception {
        HashMap<String, List<Content>> hashMap = this.map;
        synchronized (hashMap) {
            String clientid = UUID.randomUUID().toString();
            if (this.map.containsKey(clientid)) {
                throw new Exception("Message Box is existed with key:" + clientid);
            }
            this.map.put(clientid, new ArrayList());
            return clientid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyMsgBox(String key) throws Exception {
        HashMap<String, List<Content>> hashMap = this.map;
        synchronized (hashMap) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> takeMessagesFromMsgBox(String key) throws Exception {
        HashMap<String, List<Content>> hashMap = this.map;
        synchronized (hashMap) {
            List<Content> x = this.map.get(key);
            ArrayList<String> result = new ArrayList<String>(x.size());
            for (Content content : x) {
                result.add(content.getContent());
            }
            this.map.put(key, new ArrayList());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMessageIntoMsgBox(String msgBoxID, String messageID, String soapAction, OMElement message) throws Exception {
        HashMap<String, List<Content>> hashMap = this.map;
        synchronized (hashMap) {
            if (!this.map.containsKey(msgBoxID)) {
                throw new IllegalArgumentException("no message box with key " + msgBoxID + " to store the msg");
            }
            List<Content> list = this.map.get(msgBoxID);
            list.add(new Content(message.toStringWithConsume(), System.currentTimeMillis()));
            logger.debug("Message Stored in list with key " + msgBoxID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAncientMessages() {
        HashMap<String, List<Content>> hashMap = this.map;
        synchronized (hashMap) {
            long currentTime = System.currentTimeMillis();
            Iterator<List<Content>> it = this.map.values().iterator();
            while (it.hasNext()) {
                Iterator<Content> itToRemove = it.next().iterator();
                while (itToRemove.hasNext()) {
                    Content content = itToRemove.next();
                    if (currentTime - this.time <= content.getTime()) continue;
                    itToRemove.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        HashMap<String, List<Content>> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    class Content {
        private String content;
        private long time;

        public Content(String content, long time) {
            this.content = content;
            this.time = time;
        }

        public String getContent() {
            return this.content;
        }

        public long getTime() {
            return this.time;
        }
    }
}

