/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox.Storage.dbpool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.airavata.wsmg.commons.storage.JdbcStorage;
import org.apache.axiom.om.OMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBoxDB {
    private static final String MSGBOXES_TABLENAME = "msgBoxes";
    private static final String MSGBOX_TABLENAME = "msgbox";
    private static final Logger logger = LoggerFactory.getLogger(MessageBoxDB.class);
    private static Set<String> msgBoxids;
    public static final String SELECT_ALL_FROM_MSGBOXES = "SELECT * FROM msgBoxes";
    public static final String SQL_CREATE_MSGBOXES_STATEMENT = "INSERT INTO msgBoxes (msgboxid) VALUES (?)";
    public static final String SQL_DELETE_MSGBOXES_STATEMENT = "DELETE FROM msgBoxes WHERE msgboxid = ?";
    public static final String SQL_STORE_MESSAGE_STATEMENT = "INSERT INTO msgbox (content, msgboxid, messageid,soapaction) VALUES (?,?,?,?)";
    public static final String SQL_SELECT_MSGBOX_STATEMENT = "SELECT * FROM msgbox WHERE msgboxid = ? ORDER BY time";
    public static final String SQL_DELETE_MSGBOX_STATEMENT = "DELETE FROM msgbox WHERE msgboxid = ?";
    public static final String SQL_DELETE_ANCIENT_STATEMENT = "DELETE FROM msgbox WHERE {fn TIMESTAMPDIFF(SQL_TSI_FRAC_SECOND, CURRENT_TIMESTAMP, time) } > ?";
    private JdbcStorage db;
    private static MessageBoxDB instance;
    private long time;

    private MessageBoxDB(JdbcStorage db, long time) {
        this.db = db;
        this.time = time;
    }

    public static synchronized MessageBoxDB initialize(JdbcStorage db, long time) throws SQLException {
        if (instance == null) {
            instance = new MessageBoxDB(db, time);
            MessageBoxDB.setMsgBoxidList(db);
        }
        return instance;
    }

    public static MessageBoxDB getInstance() {
        if (instance == null) {
            throw new RuntimeException("Please initialize this object first using initialize(JdbcStorage, long)");
        }
        return instance;
    }

    public synchronized void createMsgBx(String messageBoxId) throws SQLException, IOException {
        if (!msgBoxids.contains(messageBoxId)) {
            Connection connection = null;
            try {
                logger.debug("msgBoxes:" + messageBoxId);
                connection = this.db.connect();
                PreparedStatement statement = connection.prepareStatement(SQL_CREATE_MSGBOXES_STATEMENT);
                statement.setString(1, messageBoxId);
                this.db.executeUpdateAndClose(statement);
                this.db.commitAndFree(connection);
                msgBoxids.add(messageBoxId);
            }
            catch (SQLException sql) {
                this.db.rollbackAndFree(connection);
                throw sql;
            }
        } else {
            throw new IOException("The message box ID requested already exists");
        }
    }

    public synchronized void addMessage(String msgBoxID, String messageID, String soapAction, OMElement message) throws SQLException, IOException, XMLStreamException {
        if (msgBoxids.contains(msgBoxID)) {
            Connection connection = null;
            try {
                connection = this.db.connect();
                PreparedStatement stmt = connection.prepareStatement(SQL_STORE_MESSAGE_STATEMENT);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(output);
                out.writeObject(message.toStringWithConsume());
                byte[] buffer = output.toByteArray();
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                stmt.setBinaryStream(1, (InputStream)in, buffer.length);
                stmt.setString(2, msgBoxID);
                stmt.setString(3, messageID);
                stmt.setString(4, soapAction);
                this.db.executeUpdateAndClose(stmt);
                this.db.commitAndFree(connection);
            }
            catch (SQLException sql) {
                this.db.rollbackAndFree(connection);
                throw sql;
            }
        } else {
            throw new IOException("Currently a messagebox is not available with given message box id :" + msgBoxID);
        }
    }

    public synchronized void deleteMessageBox(String msgBoxId) throws SQLException {
        if (msgBoxids.contains(msgBoxId)) {
            Connection connection = null;
            try {
                connection = this.db.connect();
                PreparedStatement statement = connection.prepareStatement(SQL_DELETE_MSGBOXES_STATEMENT);
                statement.setString(1, msgBoxId);
                this.db.executeUpdateAndClose(statement);
                statement = connection.prepareStatement(SQL_DELETE_MSGBOX_STATEMENT);
                statement.setString(1, msgBoxId);
                this.db.executeUpdateAndClose(statement);
                this.db.commitAndFree(connection);
                msgBoxids.remove(msgBoxId);
            }
            catch (SQLException sql) {
                this.db.rollbackAndFree(connection);
                throw sql;
            }
        }
    }

    public synchronized List<String> removeAllMessagesforClient(String msgBoxId) throws SQLException, IOException, ClassNotFoundException, XMLStreamException {
        ArrayList<String> list = new ArrayList<String>();
        if (msgBoxids.contains(msgBoxId)) {
            Connection connection = null;
            PreparedStatement stmt = null;
            PreparedStatement stmt2 = null;
            try {
                connection = this.db.connect();
                stmt = connection.prepareStatement(SQL_SELECT_MSGBOX_STATEMENT);
                stmt.setString(1, msgBoxId);
                ResultSet resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    InputStream in = resultSet.getAsciiStream("content");
                    ObjectInputStream s = new ObjectInputStream(in);
                    String xmlString = (String)s.readObject();
                    logger.debug(xmlString);
                    list.add(xmlString);
                }
                stmt2 = connection.prepareStatement(SQL_DELETE_MSGBOX_STATEMENT);
                stmt2.setString(1, msgBoxId);
                stmt2.executeUpdate();
                this.db.commit(connection);
            }
            catch (SQLException sql) {
                try {
                    this.db.rollback(connection);
                    throw sql;
                }
                catch (Throwable throwable) {
                    this.db.quietlyClose(connection, new Statement[]{stmt, stmt2});
                    throw throwable;
                }
            }
            this.db.quietlyClose(connection, new Statement[]{stmt, stmt2});
        }
        return list;
    }

    public synchronized void removeAncientMessages() {
        Connection connection = null;
        try {
            connection = this.db.connect();
            PreparedStatement stmt = connection.prepareStatement(SQL_DELETE_ANCIENT_STATEMENT);
            stmt.setLong(1, this.time);
            this.db.executeUpdateAndClose(stmt);
            this.db.commitAndFree(connection);
        }
        catch (SQLException sql) {
            this.db.rollbackAndFree(connection);
            logger.error("Caught exception while removing old entries from msgbox db table", (Throwable)sql);
        }
    }

    private static void setMsgBoxidList(JdbcStorage db) throws SQLException {
        msgBoxids = new HashSet<String>();
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = db.connect();
            stmt = connection.prepareStatement(SELECT_ALL_FROM_MSGBOXES);
            ResultSet resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                msgBoxids.add(resultSet.getString("msgboxid"));
            }
            db.commit(connection);
        }
        catch (SQLException e) {
            try {
                db.rollback(connection);
                throw e;
            }
            catch (Throwable throwable) {
                db.quietlyClose(connection, new Statement[]{stmt});
                throw throwable;
            }
        }
        db.quietlyClose(connection, new Statement[]{stmt});
    }
}

