/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox.Storage.dbpool;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.airavata.wsmg.commons.storage.DatabaseCreator;
import org.apache.airavata.wsmg.commons.storage.JdbcStorage;
import org.apache.airavata.wsmg.msgbox.Storage.MsgBoxStorage;
import org.apache.airavata.wsmg.msgbox.Storage.dbpool.MessageBoxDB;
import org.apache.axiom.om.OMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseStorageImpl
implements MsgBoxStorage {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseStorageImpl.class);
    private static final String TABLE_NAME_TO_CHECK = "msgbox";
    private JdbcStorage db;

    public DatabaseStorageImpl(String jdbcUrl, String jdbcDriver, long timeOfOldMessage) {
        this.db = new JdbcStorage(10, 50, jdbcUrl, jdbcDriver, true);
        Connection conn = null;
        try {
            conn = this.db.connect();
            if (!DatabaseCreator.isDatabaseStructureCreated((String)TABLE_NAME_TO_CHECK, (Connection)conn)) {
                DatabaseCreator.createMsgBoxDatabase((Connection)conn);
                logger.info("New Database created for Message Box");
            } else {
                logger.info("Database already created for Message Box!");
            }
            MessageBoxDB.initialize(this.db, timeOfOldMessage);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Database failure");
        }
        finally {
            this.db.closeConnection(conn);
        }
    }

    @Override
    public String createMsgBox() throws SQLException, IOException {
        String uuid = UUID.randomUUID().toString();
        MessageBoxDB.getInstance().createMsgBx(uuid);
        return uuid;
    }

    @Override
    public void destroyMsgBox(String key) throws Exception {
        try {
            MessageBoxDB.getInstance().deleteMessageBox(key);
        }
        catch (SQLException e) {
            throw new Exception("Could not destroy the message box with key " + key, e);
        }
    }

    @Override
    public List<String> takeMessagesFromMsgBox(String key) throws Exception {
        List<String> list = null;
        try {
            list = MessageBoxDB.getInstance().removeAllMessagesforClient(key);
        }
        catch (SQLException e) {
            throw new Exception("Error reading the message with the key " + key, e);
        }
        catch (IOException e) {
            throw new Exception("Error reading the message with the key " + key, e);
        }
        return list;
    }

    @Override
    public void putMessageIntoMsgBox(String msgBoxID, String messageID, String soapAction, OMElement message) throws SQLException, IOException, XMLStreamException {
        MessageBoxDB.getInstance().addMessage(msgBoxID, messageID, soapAction, message);
    }

    @Override
    public void removeAncientMessages() throws Exception {
        MessageBoxDB.getInstance().removeAncientMessages();
    }

    @Override
    public void dispose() {
        if (this.db != null) {
            this.db.closeAllConnections();
        }
    }
}

