/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.List;
import org.apache.airavata.wsmg.commons.MsgBoxQNameConstants;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.msgbox.Storage.MsgBoxStorage;
import org.apache.airavata.wsmg.msgbox.util.MsgBoxUtils;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.service.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgBoxServiceSkeleton
implements Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MsgBoxServiceSkeleton.class);
    private static final String TRUE = Boolean.toString(true);
    private static final String FALSE = Boolean.toString(false);
    private static final long SLEEP_TIME = 3600000L;
    private static OMFactory factory = OMAbstractFactory.getOMFactory();
    private MsgBoxStorage storage;
    private Thread deletingThread;
    private boolean stop;

    public void init(ServiceContext context) throws AxisFault {
        this.storage = (MsgBoxStorage)context.getConfigurationContext().getProperty("msgbox.storage");
        logger.info("Start clean up thread for messagebox");
        this.deletingThread = new Thread(new DeleteOldMessageRunnable());
        this.deletingThread.start();
    }

    public void destroy(ServiceContext context) {
        this.storage = null;
        this.stop = true;
        this.deletingThread.interrupt();
        try {
            this.deletingThread.join();
        }
        catch (Exception e) {
            logger.error("Cannot shutdown cleanup thread", (Throwable)e);
        }
    }

    public OMElement createMsgBox() throws Exception {
        try {
            String createdMsgBoxId = this.storage.createMsgBox();
            logger.debug("MsgBox created:" + createdMsgBoxId);
            OMElement dd = factory.createOMElement(MsgBoxQNameConstants.CREATE_MSGBOX_RESP_QNAME);
            OMElement url = factory.createOMElement(MsgBoxQNameConstants.MSG_BOXID_QNAME);
            url.setText(createdMsgBoxId);
            dd.addChild((OMNode)url);
            return dd;
        }
        catch (Exception e) {
            logger.error("Error creating the message box", (Throwable)e);
            AxisFault f = new AxisFault("Error creating the message box", "6000", (Throwable)e);
            throw f;
        }
    }

    public OMElement storeMessages(String msgBoxAddr, String messageID, String soapAction, OMElement message) throws Exception {
        OMElement resp = factory.createOMElement(MsgBoxQNameConstants.STOREMSG_RESP_QNAME);
        OMElement status = factory.createOMElement(MsgBoxQNameConstants.MSGBOX_STATUS_QNAME);
        try {
            this.storage.putMessageIntoMsgBox(msgBoxAddr, messageID, soapAction, message);
            logger.debug("Put Message to MsgBox:" + msgBoxAddr + " with messageID:" + messageID);
            status.setText(TRUE);
        }
        catch (SQLException e) {
            logger.error("Error while storing message: " + message + " in msgbx: " + msgBoxAddr, (Throwable)e);
            status.setText(FALSE);
        }
        resp.addChild((OMNode)status);
        resp.declareNamespace(NameSpaceConstants.MSG_BOX);
        return resp;
    }

    public OMElement takeMessages(String msgBoxAddr) throws Exception {
        try {
            OMElement respEl = factory.createOMElement(MsgBoxQNameConstants.TAKE_MSGBOX_RESP_QNAME);
            OMElement messageSet = factory.createOMElement(MsgBoxQNameConstants.MSGBOX_MESSAGE_QNAME);
            List<String> list = this.storage.takeMessagesFromMsgBox(msgBoxAddr);
            if (list != null && list.size() != 0) {
                for (String string : list) {
                    messageSet.addChild((OMNode)MsgBoxUtils.reader2OMElement(new StringReader(string)));
                }
                logger.debug("Take all messages from MsgBox:" + msgBoxAddr);
            } else {
                logger.debug("  no messages..  ");
            }
            respEl.addChild((OMNode)messageSet);
            respEl.declareNamespace(NameSpaceConstants.MSG_BOX);
            return respEl;
        }
        catch (Exception e) {
            logger.error("Error taking mesages of message box: " + msgBoxAddr, (Throwable)e);
            throw e;
        }
    }

    public OMElement destroyMsgBox(String msgBoxAddr) throws Exception {
        OMElement respEl = factory.createOMElement(MsgBoxQNameConstants.DESTROY_MSGBOX_RESP_QNAME);
        OMElement statusEl = factory.createOMElement(MsgBoxQNameConstants.MSGBOX_STATUS_QNAME);
        String addr = msgBoxAddr;
        try {
            this.storage.destroyMsgBox(addr);
            logger.debug("Destry MsgBox:" + msgBoxAddr);
            statusEl.setText(TRUE);
        }
        catch (Exception e) {
            logger.warn("Error while delete msgbx: " + msgBoxAddr, (Throwable)e);
            statusEl.setText(FALSE);
        }
        respEl.addChild((OMNode)statusEl);
        return respEl;
    }

    class DeleteOldMessageRunnable
    implements Runnable {
        DeleteOldMessageRunnable() {
        }

        @Override
        public void run() {
            while (!MsgBoxServiceSkeleton.this.stop) {
                try {
                    Thread.sleep(3600000L);
                    if (MsgBoxServiceSkeleton.this.storage == null) continue;
                    MsgBoxServiceSkeleton.this.storage.removeAncientMessages();
                }
                catch (Exception e) {
                    logger.warn("Msgbox cleanup thread is interrupted to close");
                }
            }
        }
    }
}

