/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox;

import org.apache.airavata.wsmg.msgbox.MsgBoxServiceSkeleton;
import org.apache.airavata.wsmg.msgbox.util.MsgBoxOperations;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.apache.axis2.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgBoxServiceMessageReceiverInOut
extends AbstractInOutMessageReceiver {
    private static Logger logger = LoggerFactory.getLogger(MsgBoxServiceMessageReceiverInOut.class);

    public void invokeBusinessLogic(MessageContext inMsgContext, MessageContext outMsgContext) throws AxisFault {
        MsgBoxServiceSkeleton skel = (MsgBoxServiceSkeleton)this.getTheImplementationObject(inMsgContext);
        OMElement response = null;
        try {
            String operationName = this.getOperationName(inMsgContext);
            MsgBoxOperations msgType = MsgBoxOperations.valueFrom(operationName);
            switch (msgType) {
                case STORE_MSGS: {
                    SOAPEnvelope enlp = inMsgContext.getEnvelope();
                    OMElement message = enlp.getBody().getFirstElement();
                    String msgBoxId = this.getClientId(inMsgContext);
                    String messageId = inMsgContext.getMessageID();
                    String soapAction = inMsgContext.getSoapAction();
                    response = skel.storeMessages(msgBoxId, messageId, soapAction, message);
                    break;
                }
                case DESTROY_MSGBOX: {
                    String msgBoxId = this.getClientId(inMsgContext);
                    response = skel.destroyMsgBox(msgBoxId);
                    break;
                }
                case TAKE_MSGS: {
                    String msgBoxId = this.getClientId(inMsgContext);
                    response = skel.takeMessages(msgBoxId);
                    break;
                }
                case CREATE_MSGBOX: {
                    response = skel.createMsgBox();
                    break;
                }
                default: {
                    throw new AxisFault("unsupported operation" + msgType.toString());
                }
            }
        }
        catch (AxisFault afe) {
            throw afe;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            throw new AxisFault("Exception in Message Box ", (Throwable)e);
        }
        SOAPFactory soapFactory = this.getSOAPFactory(inMsgContext);
        SOAPEnvelope envelope = this.toEnvelope(soapFactory, response);
        outMsgContext.setEnvelope(envelope);
        outMsgContext.getOptions().setProperty("__CHUNKED__", (Object)Boolean.FALSE);
    }

    private String getClientId(MessageContext inMsg) throws AxisFault {
        String toAddress = inMsg.getTo().getAddress();
        int biginIndex = toAddress.indexOf("clientid");
        if (biginIndex == -1) {
            throw new AxisFault("clientid cannot be found");
        }
        String clientId = toAddress.substring(biginIndex + "clientid".length() + 1);
        return clientId;
    }

    private SOAPEnvelope toEnvelope(SOAPFactory factory, OMElement response) {
        SOAPEnvelope envelop = factory.getDefaultEnvelope();
        envelop.getBody().addChild((OMNode)response);
        return envelop;
    }

    protected String getOperationName(MessageContext inMsg) throws AxisFault {
        AxisOperation op = inMsg.getOperationContext().getAxisOperation();
        if (op == null) {
            throw new AxisFault("Operation is not located, if this is doclit style the SOAP-ACTION should specified via the SOAP Action to use the RawXMLProvider");
        }
        String operationName = null;
        if (op.getName() == null || (operationName = JavaUtils.xmlNameToJava((String)op.getName().getLocalPart())) == null) {
            throw new AxisFault("invalid operation found");
        }
        return operationName;
    }
}

