/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox;

import java.io.File;
import org.apache.airavata.wsmg.commons.config.ConfigurationManager;
import org.apache.airavata.wsmg.commons.util.Axis2Utils;
import org.apache.airavata.wsmg.msgbox.Storage.MsgBoxStorage;
import org.apache.airavata.wsmg.msgbox.Storage.dbpool.DatabaseStorageImpl;
import org.apache.airavata.wsmg.msgbox.Storage.memory.InMemoryImpl;
import org.apache.airavata.wsmg.msgbox.StoreMessageHandler;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.dispatchers.AddressingBasedDispatcher;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgBoxServiceLifeCycle
implements ServiceLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(MsgBoxServiceLifeCycle.class);
    private static final String CONFIGURATION_FILE_NAME = "msgBox.properties";
    private static final String TRUE = Boolean.toString(true);

    public void shutDown(ConfigurationContext configurationcontext, AxisService axisservice) {
        logger.info("Message box shutting down");
        if (configurationcontext.getProperty("msgbox.storage") != null) {
            MsgBoxStorage msgBoxStorage = (MsgBoxStorage)configurationcontext.getProperty("msgbox.storage");
            msgBoxStorage.dispose();
        }
    }

    public void startUp(ConfigurationContext configurationcontext, AxisService axisservice) {
        Axis2Utils.overrideAddressingPhaseHander((ConfigurationContext)configurationcontext, (AddressingBasedDispatcher)new StoreMessageHandler());
        ConfigurationManager confmanager = new ConfigurationManager("conf" + File.separator + CONFIGURATION_FILE_NAME);
        this.initDatabase(configurationcontext, confmanager);
    }

    public void initDatabase(ConfigurationContext configurationcontext, ConfigurationManager confmanager) {
        String useDatabase = confmanager.getConfig("msgBox.usedatabase", TRUE);
        MsgBoxStorage msgBoxStorage = null;
        long time = this.getInterval(confmanager);
        if (useDatabase.equalsIgnoreCase(TRUE)) {
            String jdbcUrl = confmanager.getConfig("msgBox.jdbc.url");
            String jdbcDriver = confmanager.getConfig("msgBox.jdbc.driver");
            msgBoxStorage = new DatabaseStorageImpl(jdbcUrl, jdbcDriver, time);
        } else {
            msgBoxStorage = new InMemoryImpl(time);
        }
        configurationcontext.setProperty("msgbox.storage", (Object)msgBoxStorage);
    }

    private long getInterval(ConfigurationManager configs) {
        int messagePreservationDays = configs.getConfig("messagePreservationDays", 2);
        int messagePreservationHours = configs.getConfig("messagePreservationHours", 0);
        int messagePreservationMinutes = configs.getConfig("messagePreservationMinutes", 0);
        long interval = (long)messagePreservationDays * 24L;
        interval = (interval + (long)messagePreservationHours) * 60L;
        interval = (interval + (long)messagePreservationMinutes) * 60L;
        return interval *= 1000L;
    }
}

