/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.DataByteArrayInputStream;

public class StompCodec {
    static final byte[] crlfcrlf = new byte[]{13, 10, 13, 10};
    TcpTransport transport;
    ByteArrayOutputStream currentCommand = new ByteArrayOutputStream();
    boolean processedHeaders = false;
    String action;
    HashMap<String, String> headers;
    int contentLength = -1;
    int readLength = 0;
    int previousByte = -1;

    public StompCodec(TcpTransport transport) {
        this.transport = transport;
    }

    public void parse(ByteArrayInputStream input, int readSize) throws Exception {
        int i = 0;
        while (i++ < readSize) {
            int b = input.read();
            if (!this.processedHeaders && this.previousByte == 0 && b == 0) continue;
            if (!this.processedHeaders) {
                this.currentCommand.write(b);
                if (b == 10 && (this.previousByte == 10 || this.currentCommand.endsWith(crlfcrlf))) {
                    if (this.transport.getWireFormat() instanceof StompWireFormat) {
                        DataByteArrayInputStream data = new DataByteArrayInputStream(this.currentCommand.toByteArray());
                        this.action = ((StompWireFormat)this.transport.getWireFormat()).parseAction(data);
                        this.headers = ((StompWireFormat)this.transport.getWireFormat()).parseHeaders(data);
                        String contentLengthHeader = this.headers.get("content-length");
                        this.contentLength = (this.action.equals("SEND") || this.action.equals("MESSAGE")) && contentLengthHeader != null ? ((StompWireFormat)this.transport.getWireFormat()).parseContentLength(contentLengthHeader) : -1;
                    }
                    this.processedHeaders = true;
                    this.currentCommand.reset();
                }
            } else if (this.contentLength == -1) {
                if (b == 0) {
                    this.processCommand();
                } else {
                    this.currentCommand.write(b);
                }
            } else if (this.readLength++ == this.contentLength) {
                this.processCommand();
                this.readLength = 0;
            } else {
                this.currentCommand.write(b);
            }
            this.previousByte = b;
        }
    }

    protected void processCommand() throws Exception {
        StompFrame frame = new StompFrame(this.action, this.headers, this.currentCommand.toByteArray());
        this.transport.doConsume(frame);
        this.processedHeaders = false;
        this.currentCommand.reset();
        this.contentLength = -1;
    }
}

