/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.update;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import sparql.FilterUtils;
import sparql.ValueSet;

public class QuadFilter {
    private Set<Set<Expr>> filterDnf;
    private Quad pattern;
    private Map<Var, ValueSet<NodeValue>> varToValueSet;

    public Set<Var> getVarsMentioned() {
        return QuadUtils.getVarsMentioned((Quad)this.pattern);
    }

    public QuadFilter(Quad pattern, Set<Set<Expr>> filterDnf) {
        this.pattern = pattern;
        this.filterDnf = filterDnf;
        this.varToValueSet = FilterUtils.extractValueConstraintsDnf(filterDnf);
        System.out.println("Extracted contstraints: " + this.varToValueSet);
    }

    public QuadFilter(Quad pattern, List<ExprList> filter) {
        this.pattern = pattern;
        this.filterDnf = FilterUtils.toSets(filter);
        this.varToValueSet = FilterUtils.extractValueConstraintsDnf(this.filterDnf);
        System.out.println("Extracted contstraints: " + this.varToValueSet);
    }

    public Quad getPattern() {
        return this.pattern;
    }

    public boolean doesAccept(Quad quad) {
        if (null == QuadUtils.getVarMapping((Quad)this.pattern, (Quad)quad)) {
            return false;
        }
        if (this.filterDnf == null) {
            return true;
        }
        List p = QuadUtils.quadToList((Quad)this.pattern);
        List nodes = QuadUtils.quadToList((Quad)quad);
        for (Set<Expr> clause : this.filterDnf) {
            boolean and = true;
            for (Expr expr : clause) {
                BindingHashMap binding = new BindingHashMap();
                for (int i = 0; i < 4; ++i) {
                    Node n = (Node)p.get(i);
                    if (!n.isVariable()) continue;
                    binding.add((Var)n, (Node)nodes.get(i));
                }
                if (and = and && ExprUtils.eval((Expr)expr, (Binding)binding).getBoolean()) continue;
                break;
            }
            if (!and) continue;
            return true;
        }
        return false;
    }
}

