/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.update;

import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aksw.commons.collections.CacheSet;
import org.aksw.sparqlify.update.GraphListener;
import org.aksw.sparqlify.update.ModelSparqlEndpoint;
import sparql.FilterCompiler;

public class CleanListener
implements GraphListener {
    private Set<GraphListener> graphListeners = new HashSet<GraphListener>();
    private Set<Quad> insertCache = new CacheSet(10000, true);
    private Set<Quad> deleteCache = new CacheSet(10000, true);
    private Set<Quad> safeInserts = new HashSet<Quad>();
    private Set<Quad> safeDeletes = new HashSet<Quad>();
    private Set<Quad> verifyInserts = new HashSet<Quad>();
    private Set<Quad> verifyDeletes = new HashSet<Quad>();
    private ModelSparqlEndpoint endpoint;

    public CleanListener(ModelSparqlEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Set<Quad> verify(Collection<Quad> quads, boolean shouldExist) {
        HashSet<Quad> result = new HashSet<Quad>();
        for (Quad quad : quads) {
            String askQuery = FilterCompiler.askForQuad((Quad)quad);
            System.out.println(askQuery);
            boolean exists = this.endpoint.createQueryExecution(askQuery).execAsk();
            if (exists != shouldExist) continue;
            result.add(quad);
        }
        return result;
    }

    public void verifyInserts() {
        Set<Quad> verified = this.verify(this.verifyInserts, false);
        this.safeInserts.addAll(verified);
        this.verifyInserts.clear();
    }

    public void verifyDeletes() {
        Set<Quad> verified = this.verify(this.verifyDeletes, true);
        this.safeDeletes.addAll(verified);
        this.verifyDeletes.clear();
    }

    @Override
    public void onPreInsert(Quad quad) {
        if (this.insertCache.contains(quad)) {
            return;
        }
        if (this.deleteCache.contains(quad)) {
            this.safeInserts.add(quad);
            this.deleteCache.remove(quad);
            this.insertCache.add(quad);
        } else {
            this.verifyInserts.add(quad);
        }
    }

    @Override
    public void onPreDelete(Quad quad) {
        if (this.deleteCache.contains(quad)) {
            return;
        }
        if (this.insertCache.contains(quad)) {
            this.safeDeletes.add(quad);
            this.insertCache.remove(quad);
            this.deleteCache.add(quad);
        } else {
            this.verifyDeletes.add(quad);
        }
    }

    public Set<GraphListener> getGraphListeners() {
        return this.graphListeners;
    }

    @Override
    public void onPreBatchStart() {
    }

    @Override
    public void onPreBatchEnd() {
        this.verifyDeletes();
        this.verifyInserts();
        for (GraphListener listener : this.graphListeners) {
            listener.onPreBatchStart();
            for (Quad item : this.safeDeletes) {
                listener.onPreDelete(item);
            }
            for (Quad item : this.safeInserts) {
                listener.onPreInsert(item);
            }
            listener.onPreBatchEnd();
        }
    }

    @Override
    public void onPostBatchStart() {
    }

    @Override
    public void onPostInsert(Quad quad) {
    }

    @Override
    public void onPostDelete(Quad quad) {
    }

    @Override
    public void onPostBatchEnd() {
        for (GraphListener listener : this.graphListeners) {
            listener.onPostBatchStart();
            for (Quad item : this.safeDeletes) {
                listener.onPostDelete(item);
            }
            for (Quad item : this.safeInserts) {
                listener.onPostInsert(item);
            }
            listener.onPostBatchEnd();
        }
        this.safeInserts.clear();
        this.safeDeletes.clear();
    }
}

