/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.update;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import org.aksw.commons.collections.diff.HashSetDiff;
import org.aksw.commons.util.Files;
import org.aksw.sparqlify.update.CleanListener;
import org.aksw.sparqlify.update.IncrementalQueryUpdateManager;
import org.aksw.sparqlify.update.ModelSparqlEndpoint;
import org.aksw.sparqlify.update.UpdateGraph;

public class UpdateMain {
    public static void main(String[] args) throws Exception {
        Model testModel = ModelFactory.createDefaultModel();
        testModel.read((InputStream)new FileInputStream(new File("src/test/resources/data/base.nt")), null, "N-TRIPLE");
        ModelSparqlEndpoint endpoint = new ModelSparqlEndpoint(testModel);
        UpdateGraph graph = new UpdateGraph(endpoint);
        CleanListener cleaner = new CleanListener(endpoint);
        graph.getPreUpdateListeners().add(cleaner);
        String queryString = "Select * { ?s a <http://dbpedia.org/ontology/Person> . ?s ?p ?o . }";
        IncrementalQueryUpdateManager queryUpdates = new IncrementalQueryUpdateManager(queryString, endpoint);
        cleaner.getGraphListeners().add(queryUpdates);
        String inserts = Files.readContent((File)new File("src/test/resources/data/inserts.nt"));
        String stmt = "Insert Data {\n" + inserts + "\n}";
        graph.executeUpdate(stmt);
        UpdateMain.processChanges(queryUpdates.getChanges());
    }

    public static void print(Collection<Binding> bindings) {
        for (Binding item : bindings) {
            System.out.println(item);
        }
    }

    public static void processChanges(HashSetDiff<Binding> diff) {
        System.out.println("Added:");
        System.out.println("-----------------");
        UpdateMain.print((Collection)diff.getAdded());
        System.out.println();
        System.out.println("Removed");
        System.out.println("-----------------");
        UpdateMain.print((Collection)diff.getRemoved());
    }
}

