/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.update;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aksw.commons.util.MapReader;
import org.aksw.commons.util.jdbc.Schema;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.algorithms.CandidateViewSelectorImpl;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.IViewDef;
import org.aksw.sparqlify.core.interfaces.SqlTranslator;
import org.aksw.sparqlify.inverse.SparqlSqlInverseMapperImpl;
import org.aksw.sparqlify.util.SparqlifyUtils;
import org.aksw.sparqlify.util.ViewDefinitionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlifyUpdateExample {
    private static final Logger logger = LoggerFactory.getLogger(SparqlifyUpdateExample.class);

    public static void main(String[] args) throws Exception {
        RdfViewSystemOld.initSparqlifyFunctions();
        SqlTranslator sqlTranslator = SparqlifyUtils.createSqlRewriter();
        DataSource dataSource = SparqlifyUtils.createTestDatabase();
        Connection conn = dataSource.getConnection();
        Schema schema = Schema.create((Connection)conn);
        System.out.println(schema.getPrimaryKeys());
        Map typeAlias = MapReader.readFile((File)new File("src/main/resources/type-map.h2.tsv"));
        ViewDefinitionFactory vdf = SparqlifyUtils.createViewDefinitionFactory((Connection)conn, (Map)typeAlias);
        ViewDefinition personView = vdf.create("Prefix ex:<http://ex.org/> Create View person As Construct { ?s a ex:Person ; ex:name ?t } With ?s = uri(concat('http://ex.org/person/', ?id)) ?t = plainLiteral(?name) From person");
        ViewDefinition deptView = vdf.create("Prefix ex:<http://ex.org/> Create View dept As Construct { ?s a ex:Department ; ex:name ?t } With ?s = uri(concat('http://ex.org/dept/', ?id) ?t = plainLiteral(?name) From dept");
        ViewDefinition personToDeptView = vdf.create("Prefix ex:<http://ex.org/> Create View person_to_dept As Construct { ?p ex:worksIn ?d } With ?p = uri(concat('http://ex.org/person/', ?person_id) ?d = uri(concat('http://ex.org/dept/', ?DEPT_ID) From person_to_dept");
        CandidateViewSelectorImpl candidateViewSelector = new CandidateViewSelectorImpl();
        candidateViewSelector.addView((IViewDef)personView);
        candidateViewSelector.addView((IViewDef)deptView);
        candidateViewSelector.addView((IViewDef)personToDeptView);
        SparqlSqlInverseMapperImpl inverseMapper = new SparqlSqlInverseMapperImpl(candidateViewSelector, sqlTranslator);
        Quad insertQuad = new Quad(Quad.defaultGraphNodeGenerated, Node.createURI((String)"http://ex.org/person/5"), RDF.type.asNode(), Node.createURI((String)"http://ex.org/Person"));
        List tmp = inverseMapper.map(insertQuad);
        System.out.println(tmp);
    }
}

