/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.test;

import com.google.common.collect.Sets;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.CompareUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.resultset.ResultSetCompare;

public class TestHelper {
    public static boolean isEqual(Set<Quad> actual, Set<Quad> expected) {
        Set alignedActual = CompareUtils.alignActualQuads(expected, actual);
        Sets.SetView excessive = Sets.difference((Set)alignedActual, expected);
        Sets.SetView missing = Sets.difference(expected, (Set)alignedActual);
        if (!excessive.isEmpty() || !missing.isEmpty()) {
            System.out.println("Expected : " + expected);
            System.out.println("Actual   : " + alignedActual);
            System.out.println("Excessive: " + excessive);
            System.out.println("Missing  : " + missing);
        }
        return expected.equals(alignedActual);
    }

    public static boolean isEqual(ResultSet actual, ResultSet expected) {
        boolean isEqual = true;
        ResultSetRewindable act = null;
        ResultSetRewindable exp = null;
        if (expected != null) {
            act = ResultSetFactory.makeRewindable((ResultSet)actual);
            exp = ResultSetFactory.makeRewindable((ResultSet)expected);
            isEqual = ResultSetCompare.equalsByTerm((ResultSet)act, (ResultSet)exp);
            act.reset();
            exp.reset();
        }
        if (!isEqual) {
            String eStr = ResultSetFormatter.asText(exp);
            System.out.println("Expected");
            System.out.println("------");
            System.out.println(eStr);
            String aStr = ResultSetFormatter.asText((ResultSet)act);
            System.out.println("Actual");
            System.out.println("------");
            System.out.println(aStr);
        }
        return isEqual;
    }
}

