/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.sparqlify.core.test.MappingBundle;
import org.aksw.sparqlify.core.test.QueryBundle;
import org.aksw.sparqlify.core.test.ResourceComparator;
import org.aksw.sparqlify.core.test.TestBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class TestBundleReader {
    private static final Logger logger = LoggerFactory.getLogger(TestBundleReader.class);
    private static final Comparator<Resource> resourceComparator = new ResourceComparator();
    private static final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private String smlBasePath = "/org/aksw/sml/r2rml_tests/";
    private String r2rmlBasePath = "/org/w3c/r2rml_tests/";

    public List<TestBundle> getTestBundles() throws IOException {
        ArrayList<TestBundle> result = new ArrayList<TestBundle>();
        Resource[] resources = resolver.getResources(this.r2rmlBasePath + "*");
        Arrays.sort(resources, resourceComparator);
        for (Resource r : resources) {
            TestBundle tmp = this.process(r);
            if (tmp == null) continue;
            result.add(tmp);
        }
        return result;
    }

    public TestBundle process(Resource r) throws IOException {
        String spyPathStr = this.smlBasePath + r.getFilename() + "/";
        String r2rPathStr = this.r2rmlBasePath + r.getFilename() + "/";
        Resource spyPathRes = resolver.getResource(spyPathStr);
        Resource r2rPathRes = resolver.getResource(r2rPathStr);
        if (!spyPathRes.exists()) {
            logger.warn("Resource does not exist " + spyPathStr);
            return null;
        }
        if (!r2rPathRes.exists()) {
            logger.warn("Resource does not exist " + r2rPathStr);
            return null;
        }
        Resource create = resolver.getResource(r2rPathStr + "create.sql");
        Pattern smlPattern = Pattern.compile("sparqlify(.*).txt");
        Pattern queryPattern = Pattern.compile("query(?!result)([a-z]*)([0-9]*).txt");
        Resource[] r2rmls = resolver.getResources(spyPathStr + "sparqlify*.txt");
        Arrays.sort(r2rmls, resourceComparator);
        Resource manifest = null;
        ArrayList<MappingBundle> mappingBundles = new ArrayList<MappingBundle>();
        for (Resource m : r2rmls) {
            String name = m.getFilename();
            Matcher matcher = smlPattern.matcher(name);
            boolean isFind = matcher.find();
            if (!isFind) {
                throw new RuntimeException("Should not happen");
            }
            String subTest = matcher.group(1);
            String mappingStr = r2rPathStr + "mapped" + subTest + ".nq";
            Resource expected = resolver.getResource(mappingStr);
            if (!expected.exists()) {
                logger.warn("No expected result found for " + name + " skipping test");
                continue;
            }
            ArrayList<QueryBundle> queryBundles = new ArrayList<QueryBundle>();
            Resource[] queries = resolver.getResources(spyPathStr + "query" + subTest + "*.txt");
            Arrays.sort(queries, resourceComparator);
            for (Resource q : queries) {
                String queryName = q.getFilename();
                Matcher queryMatcher = queryPattern.matcher(queryName);
                boolean isQueryFind = queryMatcher.find();
                if (!isQueryFind) continue;
                String queryNo = queryMatcher.group(2);
                String expectedResultStr = spyPathStr + "queryresult" + subTest + queryNo + ".xml";
                Resource expectedResult = resolver.getResource(expectedResultStr);
                if (!expectedResult.exists()) {
                    logger.warn("No expected result found for " + name + " skipping test");
                    continue;
                }
                QueryBundle queryBundle = new QueryBundle(queryName, q, expectedResult);
                queryBundles.add(queryBundle);
            }
            MappingBundle mappingBundle = new MappingBundle(subTest, m, expected, queryBundles);
            mappingBundles.add(mappingBundle);
        }
        TestBundle result = new TestBundle(r.getFilename(), create, mappingBundles, manifest);
        return result;
    }
}

