/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import com.hp.hpl.jena.rdf.model.Property;
import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.Dataset;

public class MappedResource {
    private final String relativeWebURI;
    private final String datasetURI;
    private final Configuration serverConfig;
    private final Dataset datasetConfig;

    public MappedResource(String relativeWebURI, String datasetURI, Configuration config, Dataset dataset) {
        this.relativeWebURI = relativeWebURI;
        this.datasetURI = datasetURI;
        this.serverConfig = config;
        this.datasetConfig = dataset;
    }

    public Dataset getDataset() {
        return this.datasetConfig;
    }

    public String getDatasetURI() {
        return this.datasetURI;
    }

    public String getWebURI() {
        return this.serverConfig.getWebApplicationBaseURI() + this.datasetConfig.getWebResourcePrefix() + this.relativeWebURI;
    }

    public String getPageURL() {
        return this.serverConfig.getWebApplicationBaseURI() + "page/" + this.relativeWebURI;
    }

    public String getDataURL() {
        return this.serverConfig.getWebApplicationBaseURI() + "data/" + this.relativeWebURI;
    }

    public String getPathPageURL(Property property) {
        return this.getPathURL("pathpage/", property);
    }

    public String getPathDataURL(Property property) {
        return this.getPathURL("pathdata/", property);
    }

    public String getInversePathPageURL(Property property) {
        return this.getPathURL("pathpage/-", property);
    }

    public String getInversePathDataURL(Property property) {
        return this.getPathURL("pathdata/-", property);
    }

    private String getPathURL(String urlPrefix, Property property) {
        if (this.serverConfig.getPrefixes().qnameFor(property.getURI()) == null) {
            return null;
        }
        return this.serverConfig.getWebApplicationBaseURI() + urlPrefix + this.serverConfig.getPrefixes().qnameFor(property.getURI()) + "/" + this.relativeWebURI;
    }
}

