/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.platform.web;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.net.URL;
import java.security.ProtectionDomain;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryEx;
import org.aksw.sparqlify.web.HttpSparqlEndpoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainSparqlifyPlatform {
    private static final Logger logger = LoggerFactory.getLogger(MainSparqlifyPlatform.class);

    public static void main(String[] args) throws Exception {
        int port = 7531;
        System.getProperties().setProperty("configDirectory", "/home/raven/Projects/Eclipse/sparqlify-parent/sparqlify-platform/config/example/sparqlify-platform/");
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setMaxIdleTime(3600000);
        connector.setSoLingerTime(-1);
        connector.setPort(port);
        server.setConnectors(new Connector[]{connector});
        WebAppContext context = new WebAppContext();
        context.setServer(server);
        context.setContextPath("/");
        ProtectionDomain protectionDomain = MainSparqlifyPlatform.class.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        String externalForm = location.toExternalForm();
        if (externalForm.endsWith("/classes/")) {
            externalForm = "src/main/webapp";
        }
        logger.debug("Loading webAppContext from " + externalForm);
        context.setWar(externalForm);
        server.setHandler((Handler)context);
        try {
            server.start();
            System.in.read();
            server.stop();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    public static Server createSparqlEndpoint(QueryExecutionFactoryEx qef, int port) throws Exception {
        HttpSparqlEndpoint.sparqler = qef;
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", "org.aksw.sparqlify.web");
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.getServletContext().setAttribute("queryExecutionFactory", (Object)qef);
        context.addServlet(sh, "/*");
        return server;
    }
}

