/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.platform.config;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import de.fuberlin.wiwiss.pubby.DataSource;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;

public class QefDataSource
implements DataSource {
    private String previousDescribeQuery;
    private QueryExecutionFactory qef;
    private String endpointURN;

    public QefDataSource(QueryExecutionFactory qef, String endpointURN) {
        this.qef = qef;
        this.endpointURN = endpointURN;
    }

    @Override
    public String getEndpointURL() {
        return this.endpointURN;
    }

    @Override
    public String getResourceDescriptionURL(String resourceURI) {
        return "DESCRIBE <" + resourceURI + ">";
    }

    @Override
    public Model getResourceDescription(String resourceURI) {
        return this.execDescribeQuery("DESCRIBE <" + resourceURI + ">");
    }

    @Override
    public Model getAnonymousPropertyValues(String resourceURI, Property property, boolean isInverse) {
        String query = "DESCRIBE ?x WHERE { " + (isInverse ? "?x <" + property.getURI() + "> <" + resourceURI + "> . " : "<" + resourceURI + "> <" + property.getURI() + "> ?x . ") + "FILTER (isBlank(?x)) }";
        Model result = this.execDescribeQuery(query);
        return result;
    }

    public String getPreviousDescribeQuery() {
        return this.previousDescribeQuery;
    }

    private Model execDescribeQuery(String query) {
        this.previousDescribeQuery = query;
        QueryExecution qe = this.qef.createQueryExecution(query);
        Model result = qe.execDescribe();
        return result;
    }
}

