/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityHelper {
    private static final String VELOCITY_ENGINE = VelocityHelper.class.getName() + ".VELOCITY_ENGINE";
    private final ServletContext servletContext;
    private final HttpServletResponse response;
    private final Context velocityContext;

    public VelocityHelper(ServletContext servletContext, HttpServletResponse response) {
        this.servletContext = servletContext;
        this.response = response;
        this.velocityContext = new VelocityContext();
    }

    public Context getVelocityContext() {
        return this.velocityContext;
    }

    public void renderXHTML(String templateName) {
        this.response.addHeader("Content-Type", "text/html; charset=utf-8");
        this.response.addHeader("Cache-Control", "no-cache");
        this.response.addHeader("Pragma", "no-cache");
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.response.getOutputStream(), "utf-8");
            this.getVelocityEngine().mergeTemplate(templateName, this.velocityContext, (Writer)writer);
            writer.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VelocityEngine getVelocityEngine() {
        ServletContext servletContext = this.servletContext;
        synchronized (servletContext) {
            if (this.servletContext.getAttribute(VELOCITY_ENGINE) == null) {
                this.servletContext.setAttribute(VELOCITY_ENGINE, (Object)this.createVelocityEngine());
            }
            return (VelocityEngine)this.servletContext.getAttribute(VELOCITY_ENGINE);
        }
    }

    private VelocityEngine createVelocityEngine() {
        try {
            VelocityEngine result = new VelocityEngine();
            result.setProperty("output.encoding", (Object)"utf-8");
            result.setProperty("file.resource.loader.path", (Object)(this.servletContext.getRealPath("/") + "/WEB-INF/templates/"));
            result.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
            result.init();
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

