/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.fuberlin.wiwiss.pubby.Dataset;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.vocab.CONF;
import java.util.ArrayList;
import java.util.Collection;

public class Configuration {
    private final Model model;
    private final Resource config;
    private final PrefixMapping prefixes;
    private final Collection labelProperties;
    private final Collection commentProperties;
    private final Collection imageProperties;
    private final Collection datasets;

    public Configuration(Model configurationModel) {
        this.model = configurationModel;
        StmtIterator it = this.model.listStatements(null, RDF.type, (RDFNode)CONF.Configuration);
        if (!it.hasNext()) {
            throw new IllegalArgumentException("No conf:Configuration found in configuration model");
        }
        this.config = it.nextStatement().getSubject();
        this.datasets = new ArrayList();
        it = this.model.listStatements(this.config, CONF.dataset, (RDFNode)null);
        while (it.hasNext()) {
            this.datasets.add(new Dataset(it.nextStatement().getResource()));
        }
        this.labelProperties = new ArrayList();
        it = this.model.listStatements(this.config, CONF.labelProperty, (RDFNode)null);
        while (it.hasNext()) {
            this.labelProperties.add(it.nextStatement().getObject().as(Property.class));
        }
        if (this.labelProperties.isEmpty()) {
            this.labelProperties.add(RDFS.label);
            this.labelProperties.add(DC.title);
            this.labelProperties.add(this.model.createProperty("http://xmlns.com/foaf/0.1/name"));
        }
        this.commentProperties = new ArrayList();
        it = this.model.listStatements(this.config, CONF.commentProperty, (RDFNode)null);
        while (it.hasNext()) {
            this.commentProperties.add(it.nextStatement().getObject().as(Property.class));
        }
        if (this.commentProperties.isEmpty()) {
            this.commentProperties.add(RDFS.comment);
            this.commentProperties.add(DC.description);
        }
        this.imageProperties = new ArrayList();
        it = this.model.listStatements(this.config, CONF.imageProperty, (RDFNode)null);
        while (it.hasNext()) {
            this.imageProperties.add(it.nextStatement().getObject().as(Property.class));
        }
        if (this.imageProperties.isEmpty()) {
            this.imageProperties.add(this.model.createProperty("http://xmlns.com/foaf/0.1/depiction"));
        }
        this.prefixes = new PrefixMappingImpl();
        if (this.config.hasProperty(CONF.usePrefixesFrom)) {
            it = this.config.listProperties(CONF.usePrefixesFrom);
            while (it.hasNext()) {
                Statement stmt = it.nextStatement();
                String uri = stmt.getResource().getURI();
                this.prefixes.setNsPrefixes((PrefixMapping)FileManager.get().loadModel(uri));
            }
        } else {
            this.prefixes.setNsPrefixes((PrefixMapping)this.model);
        }
        if (this.prefixes.getNsURIPrefix("http://richard.cyganiak.de/2007/pubby/config.rdf#") != null) {
            this.prefixes.removeNsPrefix(this.prefixes.getNsURIPrefix("http://richard.cyganiak.de/2007/pubby/config.rdf#"));
        }
    }

    public MappedResource getMappedResourceFromDatasetURI(String datasetURI) {
        for (Dataset dataset : this.datasets) {
            if (!dataset.isDatasetURI(datasetURI)) continue;
            return dataset.getMappedResourceFromDatasetURI(datasetURI, this);
        }
        return null;
    }

    public MappedResource getMappedResourceFromRelativeWebURI(String relativeWebURI, boolean isResourceURI) {
        for (Dataset dataset : this.datasets) {
            MappedResource resource = dataset.getMappedResourceFromRelativeWebURI(relativeWebURI, isResourceURI, this);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public PrefixMapping getPrefixes() {
        return this.prefixes;
    }

    public Collection getLabelProperties() {
        return this.labelProperties;
    }

    public Collection getCommentProperties() {
        return this.commentProperties;
    }

    public Collection getImageProperties() {
        return this.imageProperties;
    }

    public String getDefaultLanguage() {
        if (!this.config.hasProperty(CONF.defaultLanguage)) {
            return null;
        }
        return this.config.getProperty(CONF.defaultLanguage).getString();
    }

    public MappedResource getIndexResource() {
        if (!this.config.hasProperty(CONF.indexResource)) {
            return null;
        }
        return this.getMappedResourceFromDatasetURI(this.config.getProperty(CONF.indexResource).getResource().getURI());
    }

    public String getProjectLink() {
        return this.config.getProperty(CONF.projectHomepage).getResource().getURI();
    }

    public String getProjectName() {
        return this.config.getProperty(CONF.projectName).getString();
    }

    public String getWebApplicationBaseURI() {
        return this.config.getProperty(CONF.webBase).getResource().getURI();
    }
}

