/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import de.fuberlin.wiwiss.pubby.DataSource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;

public class RemoteSPARQLDataSource
implements DataSource {
    private String endpointURL;
    private String defaultGraphName;
    private String previousDescribeQuery;

    public RemoteSPARQLDataSource(String endpointURL, String defaultGraphName) {
        this.endpointURL = endpointURL;
        this.defaultGraphName = defaultGraphName;
    }

    @Override
    public String getEndpointURL() {
        return this.endpointURL;
    }

    @Override
    public String getResourceDescriptionURL(String resourceURI) {
        try {
            StringBuffer result = new StringBuffer();
            result.append(this.endpointURL);
            result.append("?");
            if (this.defaultGraphName != null) {
                result.append("default-graph-uri=");
                result.append(URLEncoder.encode(this.defaultGraphName, "utf-8"));
                result.append("&");
            }
            result.append("query=");
            result.append(URLEncoder.encode("DESCRIBE <" + resourceURI + ">", "utf-8"));
            return result.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Model getResourceDescription(String resourceURI) {
        return this.execDescribeQuery("DESCRIBE <" + resourceURI + ">");
    }

    @Override
    public Model getAnonymousPropertyValues(String resourceURI, Property property, boolean isInverse) {
        String query = "DESCRIBE ?x WHERE { " + (isInverse ? "?x <" + property.getURI() + "> <" + resourceURI + "> . " : "<" + resourceURI + "> <" + property.getURI() + "> ?x . ") + "FILTER (isBlank(?x)) }";
        return this.execDescribeQuery(query);
    }

    public String getPreviousDescribeQuery() {
        return this.previousDescribeQuery;
    }

    private Model execDescribeQuery(String query) {
        this.previousDescribeQuery = query;
        QueryEngineHTTP endpoint = new QueryEngineHTTP(this.endpointURL, query);
        if (this.defaultGraphName != null) {
            endpoint.setDefaultGraphURIs(Collections.singletonList(this.defaultGraphName));
        }
        return endpoint.execDescribe();
    }
}

