/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ModelResponse;
import de.fuberlin.wiwiss.pubby.ResourceDescription;
import de.fuberlin.wiwiss.pubby.servlets.BaseURLServlet;
import de.fuberlin.wiwiss.pubby.vocab.FOAF;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DataURLServlet
extends BaseURLServlet {
    @Override
    protected boolean doGet(MappedResource resource, HttpServletRequest request, HttpServletResponse response, Configuration config) throws IOException {
        String pathDataURL;
        Statement stmt;
        String datasetURI = resource.getDatasetURI();
        String webURI = resource.getWebURI();
        Model description = this.getResourceDescription(resource);
        if (description.size() == 0L) {
            response.setStatus(404);
            response.setContentType("text/plain");
            response.getOutputStream().println("Nothing known about <" + webURI + ">");
            return true;
        }
        Resource r = description.getResource(webURI);
        if (resource.getDataset().getAddSameAsStatements()) {
            r.addProperty(OWL.sameAs, (RDFNode)description.createResource(datasetURI));
        }
        StmtIterator it = r.listProperties();
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (!stmt.getObject().isAnon()) continue;
            pathDataURL = resource.getPathDataURL(stmt.getPredicate());
            stmt.getResource().addProperty(RDFS.seeAlso, (RDFNode)description.createResource(pathDataURL));
        }
        it = description.listStatements(null, null, (RDFNode)r);
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (!stmt.getSubject().isAnon()) continue;
            pathDataURL = resource.getInversePathDataURL(stmt.getPredicate());
            ((Resource)stmt.getSubject().as(Resource.class)).addProperty(RDFS.seeAlso, (RDFNode)description.createResource(pathDataURL));
        }
        if (description.qnameFor(FOAF.primaryTopic.getURI()) == null && description.getNsPrefixURI("foaf") == null) {
            description.setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        }
        if (description.qnameFor(RDFS.label.getURI()) == null && description.getNsPrefixURI("rdfs") == null) {
            description.setNsPrefix("rdfs", RDFS.getURI());
        }
        Resource document = description.getResource(this.addQueryString(resource.getDataURL(), request));
        document.addProperty(FOAF.primaryTopic, (RDFNode)r);
        document.addProperty(RDFS.label, "RDF description of " + new ResourceDescription(resource, description, config).getLabel());
        resource.getDataset().addDocumentMetadata(description, document);
        resource.getDataset().addMetadataFromTemplate(description, resource, this.getServletContext());
        ModelResponse server = new ModelResponse(description, request, response);
        server.serve();
        return true;
    }
}

