/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.jpa;

import com.hp.hpl.jena.sparql.core.Quad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.inverse.SparqlSqlInverseMap;
import org.aksw.sparqlify.inverse.SparqlSqlInverseMapper;
import org.aksw.sparqlify.jpa.EntityInverseMapper;
import org.aksw.sparqlify.jpa.EntityRef;
import org.aksw.sparqlify.util.SqlOpUtils;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityInverseMapperImplHibernate
implements EntityInverseMapper {
    private static final Logger logger = LoggerFactory.getLogger(EntityInverseMapperImplHibernate.class);
    private SparqlSqlInverseMapper inverseMapper;
    private Map<String, AbstractEntityPersister> tableNameToPersister;

    public EntityInverseMapperImplHibernate(SparqlSqlInverseMapper inverseMapper, Map<String, AbstractEntityPersister> tableNameToPersister) {
        this.inverseMapper = inverseMapper;
        this.tableNameToPersister = tableNameToPersister;
    }

    @Override
    public List<EntityRef> map(Quad quad) {
        List invMaps = this.inverseMapper.map(quad);
        ArrayList<EntityRef> result = new ArrayList<EntityRef>(invMaps.size());
        for (SparqlSqlInverseMap invMap : invMaps) {
            EntityRef entityRef = this.map(invMap);
            if (entityRef == null) continue;
            result.add(entityRef);
        }
        return result;
    }

    public EntityRef map(SparqlSqlInverseMap invMap) {
        EntityRef result = EntityInverseMapperImplHibernate.map(invMap, this.tableNameToPersister);
        return result;
    }

    public static EntityRef map(SparqlSqlInverseMap invMap, Map<String, AbstractEntityPersister> metadata) {
        String tableName = SqlOpUtils.getTableName((SqlOp)invMap.getViewDefinition().getMapping().getSqlOp());
        EntityRef result = null;
        if (tableName != null) {
            Map<String, Object> columnToValue = EntityInverseMapperImplHibernate.makeSimple(invMap.getColumnToValue());
            result = EntityInverseMapperImplHibernate.map(tableName, columnToValue, metadata);
        }
        return result;
    }

    public static EntityInverseMapperImplHibernate create(SparqlSqlInverseMapper inverseMapper, SessionFactory sessionFactory) {
        Map<String, AbstractEntityPersister> tableNameToPersister = EntityInverseMapperImplHibernate.createTablePersisterMap(sessionFactory);
        EntityInverseMapperImplHibernate result = new EntityInverseMapperImplHibernate(inverseMapper, tableNameToPersister);
        return result;
    }

    public static Map<String, Object> makeSimple(Map<S_ColumnRef, SqlValue> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<S_ColumnRef, SqlValue> entry : map.entrySet()) {
            S_ColumnRef colRef = entry.getKey();
            SqlValue sqlValue = entry.getValue();
            String columnName = colRef.getColumnName();
            Object value = sqlValue.getValue();
            result.put(columnName, value);
        }
        return result;
    }

    public static EntityRef map(String tableName, Map<String, Object> columnConstraints, Map<String, AbstractEntityPersister> metadata) {
        String[] propertyNames;
        AbstractEntityPersister persister = metadata.get(tableName);
        if (persister == null) {
            return null;
        }
        HashMap<String, String> columnToProperty = new HashMap<String, String>();
        for (String propertyName : propertyNames = persister.getPropertyNames()) {
            String[] columnNames = persister.getPropertyColumnNames(propertyName);
            if (columnNames.length > 1 || columnNames.length == 0) {
                logger.warn("Skipped property with multi column mapping: " + propertyName + " -> " + columnNames);
                continue;
            }
            String string2 = columnNames[0];
            string2 = string2.toLowerCase();
            columnToProperty.put(string2, propertyName);
        }
        String idPropertyName = persister.getIdentifierPropertyName();
        String[] idColumnNames = persister.getIdentifierColumnNames();
        if (idColumnNames.length == 1) {
            String idColumnName = idColumnNames[0];
            columnToProperty.put(idColumnName, idPropertyName);
        }
        HashMap<String, Object> propertyToValue = new HashMap<String, Object>();
        boolean allMatch = true;
        for (Map.Entry entry : columnConstraints.entrySet()) {
            String columnName = (String)entry.getKey();
            Object value = entry.getValue();
            String propertyName = (String)columnToProperty.get(columnName);
            if (propertyName == null) {
                allMatch = false;
                break;
            }
            propertyToValue.put(propertyName, value);
        }
        Class entityClass = persister.getMappedClass();
        EntityRef entityRef = allMatch ? new EntityRef(entityClass, propertyToValue) : null;
        return entityRef;
    }

    public static Map<String, AbstractEntityPersister> createTablePersisterMap(SessionFactory sessionFactory) {
        HashMap<String, AbstractEntityPersister> result = new HashMap<String, AbstractEntityPersister>();
        Collection classMetadatas = sessionFactory.getAllClassMetadata().values();
        for (ClassMetadata classMetadata : classMetadatas) {
            if (!(classMetadata instanceof AbstractEntityPersister)) continue;
            AbstractEntityPersister persister = (AbstractEntityPersister)classMetadata;
            String tmpTableName = persister.getTableName();
            String tableName = tmpTableName.toLowerCase();
            logger.warn("[HACK] Converted table name '" + tmpTableName + "' to '" + tableName + "', but this should be done via the SQL dialect or something");
            result.put(tableName, persister);
        }
        return result;
    }
}

