/*
 * Decompiled with CFR 0.152.
 */
package sparql;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import org.apache.commons.lang.NotImplementedException;

class Utils {
    Utils() {
    }

    public static boolean eval(ExprList exprs, Binding binding) {
        boolean result = true;
        if (exprs == null) {
            return result;
        }
        for (Expr expr : exprs) {
            if (result = result && ExprUtils.eval((Expr)expr, (Binding)binding).getBoolean()) continue;
            break;
        }
        return result;
    }

    public static boolean isSolutionCandidate(Op op, Binding binding) {
        if (op instanceof OpLeftJoin) {
            OpLeftJoin x = (OpLeftJoin)op;
            return Utils.eval(x.getExprs(), binding) && Utils.isSolutionCandidate(x.getLeft(), binding) && Utils.isSolutionCandidate(x.getRight(), binding);
        }
        if (op instanceof OpFilter) {
            OpFilter x = (OpFilter)op;
            return Utils.eval(x.getExprs(), binding) && Utils.isSolutionCandidate(x.getSubOp(), binding);
        }
        if (op instanceof OpJoin) {
            OpJoin x = (OpJoin)op;
            return Utils.isSolutionCandidate(x.getLeft(), binding) && Utils.isSolutionCandidate(x.getRight(), binding);
        }
        if (op instanceof OpUnion) {
            OpUnion x = (OpUnion)op;
            return Utils.isSolutionCandidate(x.getLeft(), binding) || Utils.isSolutionCandidate(x.getRight(), binding);
        }
        if (op instanceof OpQuadPattern) {
            return true;
        }
        throw new NotImplementedException("Type: " + op.getClass());
    }
}

