/*
 * Decompiled with CFR 0.152.
 */
package sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MultiMaps;
import sparql.Equivalence;
import sparql.IPatternSignature;
import sparql.IndexOpVisitor;
import sparql.QuadSignature;

public class PatternSignatureIndex {
    private Query query;
    private Map<IPatternSignature, Set<Quad>> typeToPattern = new HashMap<IPatternSignature, Set<Quad>>();

    public PatternSignatureIndex(QuadPattern quadPattern) {
        for (Quad quad : quadPattern) {
            QuadSignature type = Equivalence.getSignature(quad);
            MultiMaps.put(this.typeToPattern, (Object)type, (Object)quad);
        }
    }

    @Deprecated
    public PatternSignatureIndex(Query query) {
        this.query = query;
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        IndexOpVisitor visitor = new IndexOpVisitor();
        op.visit((OpVisitor)visitor);
        for (Quad quad : visitor.quads) {
            QuadSignature type = Equivalence.getSignature(quad);
            MultiMaps.put(this.typeToPattern, (Object)type, (Object)quad);
        }
        System.out.println("Algebra: " + op);
        System.out.println("Type: " + this.typeToPattern);
    }

    public Map<IPatternSignature, Set<Quad>> getTypeToPattern() {
        return this.typeToPattern;
    }
}

