/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.aksw.sparqlify.core.sparql.QueryEx;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryEx;
import org.aksw.sparqlify.core.sparql.QueryFactoryEx;
import org.aksw.sparqlify.web.SparqlFormatterUtils;
import org.aksw.sparqlify.web.Writer;

public class ProcessQuery {
    public static <T> StreamingOutput wrapWriter(final QueryExecution qe, final Writer<T> writer, final T obj) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                writer.write(output, obj);
                qe.close();
                output.flush();
            }
        };
    }

    public static StreamingOutput processQuery(String queryString, String format, QueryExecutionFactoryEx qeFactory) throws Exception {
        QueryEx queryEx = QueryFactoryEx.create(queryString);
        StreamingOutput result = ProcessQuery.processQuery(queryEx, format, qeFactory);
        return result;
    }

    public static StreamingOutput processQuery(QueryEx queryEx, String format, QueryExecutionFactoryEx qeFactory) throws Exception {
        QueryExecution qe = qeFactory.createQueryExecution(queryEx);
        StreamingOutput result = ProcessQuery.processQuery(queryEx, format, qe);
        return result;
    }

    public static StreamingOutput processQuery(QueryEx query, String format, QueryExecution qe) throws Exception {
        try {
            if (query.isAskType()) {
                Writer<Boolean> writer = SparqlFormatterUtils.getBooleanWriter(format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: Boolean -> " + format);
                }
                boolean value = qe.execAsk();
                return ProcessQuery.wrapWriter(qe, writer, value);
            }
            if (query.isConstructType()) {
                Writer<Iterator<Triple>> writer = SparqlFormatterUtils.getTripleWriter(format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: Model -> " + format);
                }
                Iterator it = qe.execConstructTriples();
                return ProcessQuery.wrapWriter(qe, writer, it);
            }
            if (query.isSelectType()) {
                Writer<ResultSet> writer = SparqlFormatterUtils.getResultSetWriter(format);
                if (writer == null) {
                    throw new RuntimeException("No writer found: ResultSet -> " + format);
                }
                ResultSet resultSet = qe.execSelect();
                return ProcessQuery.wrapWriter(qe, writer, resultSet);
            }
            if (query.isDescribeType()) {
                Writer<Model> writer = SparqlFormatterUtils.getModelWriter(format);
                if (writer == null) {
                    throw new RuntimeException("No formatter found: Model -> " + format);
                }
                Model model = ModelFactory.createDefaultModel();
                model.setNsPrefix("lgd-owl", "http://linkedgeodata.org/ontology/");
                model.setNsPrefix("lgd-node", "http://linkedgeodata.org/resource/node/");
                model.setNsPrefix("lgd-way", "http://linkedgeodata.org/resource/way/");
                qe.execDescribe(model);
                return ProcessQuery.wrapWriter(qe, writer, model);
            }
            throw new RuntimeException("Unknown query type");
        }
        catch (Exception e) {
            if (qe != null) {
                qe.close();
            }
            throw e;
        }
    }
}

