/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Conditional;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprNotComparableException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.aksw.sparqlify.core.SparqlifyConstants;
import org.aksw.sparqlify.core.algorithms.ExprEvaluator;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.aksw.sparqlify.trash.ExprCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprEvaluatorPartial
implements ExprEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(ExprEvaluatorPartial.class);
    private FunctionRegistry registry;

    public ExprEvaluatorPartial(FunctionRegistry registry) {
        this.registry = registry;
    }

    public static boolean isConstantsOnly(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantArgsOnly(ExprFunction fn) {
        boolean result = ExprEvaluatorPartial.isConstantsOnly(fn.getArgs());
        return result;
    }

    public Expr eval(ExprFunction fn, Map<Var, Expr> binding) {
        NodeValue newExpr;
        if (fn instanceof E_Conditional) {
            E_Conditional cond = (E_Conditional)fn;
            Expr a = this.eval(cond.getArg1(), binding);
            if (a.equals(SparqlifyConstants.nvTypeError)) {
                newExpr = SparqlifyConstants.nvTypeError;
            } else {
                Expr b = this.eval(cond.getArg2(), binding);
                Expr c = this.eval(cond.getArg3(), binding);
                newExpr = new E_Conditional(a, b, c);
            }
        } else {
            ArrayList<Expr> evaledArgs = new ArrayList<Expr>();
            for (Expr arg : fn.getArgs()) {
                Expr evaledArg = this.eval(arg, binding);
                if (evaledArg == null) {
                    throw new RuntimeException("Null must not happen here");
                }
                if (evaledArg.equals(SparqlifyConstants.nvTypeError)) {
                    return SparqlifyConstants.nvTypeError;
                }
                evaledArgs.add(evaledArg);
            }
            newExpr = ExprCopy.getInstance().copy(fn, evaledArgs);
        }
        NodeValue tmp = newExpr;
        if (tmp.isFunction() && !ExprEvaluatorPartial.isConstantArgsOnly(tmp.getFunction())) {
            return tmp;
        }
        HashSet<String> builtInOps = new HashSet<String>(Arrays.asList("<=", "<", "=", "!=", ">", ">=", "if", "&&", "||", "!", "+", "-", "*", "/"));
        String fnIri = ExprUtils.getFunctionId(fn);
        if (fnIri != null && !fnIri.isEmpty() && !builtInOps.contains(fnIri) && this.registry.get(fnIri) == null) {
            return tmp;
        }
        NodeValue result = tmp;
        try {
            result = com.hp.hpl.jena.sparql.util.ExprUtils.eval((Expr)tmp);
        }
        catch (ExprNotComparableException e) {
            return SparqlifyConstants.nvTypeError;
        }
        catch (Exception e) {
            logger.warn("Failed to evaluate expr: " + tmp);
        }
        return result;
    }

    @Override
    public Expr eval(Expr expr, Map<Var, Expr> binding) {
        if (expr == null) {
            throw new RuntimeException("Null expression should not happen");
        }
        Expr result = null;
        if (expr.isConstant()) {
            result = expr;
        } else if (expr.isFunction()) {
            ExprFunction fn = expr.getFunction();
            result = this.eval(fn, binding);
        } else if (expr.isVariable()) {
            Expr boundExpr;
            result = expr;
            if (binding != null && (boundExpr = binding.get(expr.asVar())) != null) {
                result = this.eval(boundExpr, null);
            }
        } else {
            throw new RuntimeException("Unknown expression type encountered: " + expr);
        }
        return result;
    }

    @Override
    public Expr transform(Expr expr) {
        Expr result = this.eval(expr, null);
        return result;
    }
}

