/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.aksw.jena_sparql_api.core.QueryExecutionAdapter;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Agg;
import org.aksw.sparqlify.algebra.sql.exprs2.S_AggCount;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpSelectBlock;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpUnionN;
import org.aksw.sparqlify.core.domain.input.SparqlSqlOpRewrite;
import org.aksw.sparqlify.core.interfaces.SparqlSqlOpRewriter;
import org.aksw.sparqlify.core.interfaces.SqlOpSerializer;
import org.aksw.sparqlify.core.sparql.QueryExecutionSelect;
import org.aksw.sparqlify.core.sparql.WatchDog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionSparqlifyExplain
extends QueryExecutionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionSparqlifyExplain.class);
    private Query query;
    private SparqlSqlOpRewriter sparqlSqlOpRewriter;
    private SqlOpSerializer sqlOpSerializer;
    private DataSource dataSource;
    private int queryTimeOutInSeconds = 3;

    public QueryExecutionSparqlifyExplain(Query query, SparqlSqlOpRewriter sparqlSqlOpRewriter, SqlOpSerializer sqlOpSerializer, DataSource dataSource) {
        this.query = query;
        this.sparqlSqlOpRewriter = sparqlSqlOpRewriter;
        this.sqlOpSerializer = sqlOpSerializer;
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execSelect() {
        SqlOpSelectBlock b;
        SqlOp subOp;
        Var idVar = Var.alloc((String)"id");
        Var executionTimeVar = Var.alloc((String)"executionTime");
        Var timeOutVar = Var.alloc((String)"timeOut");
        Var resultSetSizeVar = Var.alloc((String)"resultSetSize");
        Var isErrorVar = Var.alloc((String)"isError");
        Var errorMsgVar = Var.alloc((String)"errorMsg");
        Var queryStringVar = Var.alloc((String)"queryString");
        List<String> resultVars = Arrays.asList(idVar.getVarName(), executionTimeVar.getVarName(), timeOutVar.getVarName(), resultSetSizeVar.getVarName(), isErrorVar.getVarName(), errorMsgVar.getVarName(), queryStringVar.getVarName());
        ArrayList<BindingHashMap> resultBindings = new ArrayList<BindingHashMap>();
        SparqlSqlOpRewrite ssoRewrite = this.sparqlSqlOpRewriter.rewrite(this.query);
        SqlOp sqlOp = ssoRewrite.getSqlOp();
        int id = 0;
        List<SqlOp> sqlOps = null;
        if (sqlOp instanceof SqlOpSelectBlock && (subOp = (b = (SqlOpSelectBlock)sqlOp).getSubOp()) instanceof SqlOpUnionN) {
            SqlOpUnionN u = (SqlOpUnionN)subOp;
            sqlOps = u.getSubOps();
        }
        if (sqlOps == null) {
            sqlOps = Arrays.asList(sqlOp);
        }
        for (SqlOp member : sqlOps) {
            SqlOpSelectBlock m = (SqlOpSelectBlock)member;
            SqlOpSelectBlock block = SqlOpSelectBlock.create(m.getSubOp());
            block.getConditions().addAll(m.getConditions());
            block.setLimit(100L);
            block.setAliasName("a");
            SqlOpSelectBlock wrapper = SqlOpSelectBlock.create(block);
            wrapper.getProjection().put("cnt", new S_Agg(new S_AggCount()));
            ++id;
            String sqlQueryString = this.sqlOpSerializer.serialize(wrapper);
            logger.info("Query String:\n" + sqlQueryString);
            long start = System.currentTimeMillis();
            long queryTimeOutInMillis = this.queryTimeOutInSeconds * 1000;
            boolean timeOut = true;
            Node resultSetSizeNode = null;
            Node errorMsgNode = null;
            boolean isError = false;
            Connection conn = null;
            java.sql.ResultSet sqlRs = null;
            long elapsedTimeInMillis = 0L;
            try {
                Thread thread = null;
                WatchDog watchDog = null;
                try {
                    conn = this.dataSource.getConnection();
                    conn.setAutoCommit(false);
                    Statement stmt = QueryExecutionSelect.createStatement(conn);
                    try {
                        stmt.setQueryTimeout(this.queryTimeOutInSeconds);
                    }
                    catch (Exception e) {
                        logger.warn("Query time out not natively supported - falling back to custom solution");
                        watchDog = new WatchDog(stmt, queryTimeOutInMillis);
                        thread = new Thread(watchDog);
                        thread.start();
                    }
                    sqlRs = stmt.executeQuery(sqlQueryString);
                }
                finally {
                    if (thread != null) {
                        timeOut = false;
                        watchDog.cancel();
                    }
                    long end = System.currentTimeMillis();
                    elapsedTimeInMillis = end - start;
                }
                sqlRs.next();
                long resultSetSize = sqlRs.getLong("cnt");
                resultSetSizeNode = NodeValue.makeInteger((long)resultSetSize).asNode();
            }
            catch (SQLTimeoutException e) {
                timeOut = true;
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                errorMsgNode = NodeValue.makeString((String)errorMsg).asNode();
                isError = true;
                if (elapsedTimeInMillis >= queryTimeOutInMillis) {
                    timeOut = true;
                }
            }
            finally {
                if (sqlRs != null) {
                    try {
                        sqlRs.close();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            BindingHashMap binding = new BindingHashMap();
            binding.add(idVar, NodeValue.makeInteger((long)id).asNode());
            binding.add(executionTimeVar, NodeValue.makeInteger((long)elapsedTimeInMillis).asNode());
            binding.add(timeOutVar, NodeValue.makeBoolean((boolean)timeOut).asNode());
            binding.add(resultSetSizeVar, resultSetSizeNode);
            binding.add(isErrorVar, NodeValue.makeBoolean((boolean)isError).asNode());
            binding.add(errorMsgVar, errorMsgNode);
            binding.add(queryStringVar, NodeValue.makeString((String)sqlQueryString).asNode());
            resultBindings.add(binding);
        }
        QueryIterPlainWrapper queryIterator = new QueryIterPlainWrapper(resultBindings.iterator());
        ResultSet result = ResultSetFactory.create((QueryIterator)queryIterator, resultVars);
        return result;
    }
}

