/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sdb.core.JoinType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.factory.Factory1;
import org.aksw.commons.util.jdbc.ColumnsReference;
import org.aksw.commons.util.jdbc.Index;
import org.aksw.commons.util.jdbc.Schema;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Equals;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpJoin;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpJoinN;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpLeaf;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpSelectBlock;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSortCondition;
import org.aksw.sparqlify.core.algorithms.AliasSubstitutor;
import org.aksw.sparqlify.core.algorithms.EdgeSelfJoin;
import org.aksw.sparqlify.core.algorithms.SelfJoinResult;
import org.aksw.sparqlify.core.algorithms.SqlExprSubstitutor2;
import org.aksw.sparqlify.core.algorithms.SqlExprUtils;
import org.jgrapht.graph.SimpleGraph;

public class SqlOptimizerImpl {
    private Schema dbSchema;

    public SqlOptimizerImpl(Schema dbSchema) {
        this.dbSchema = dbSchema;
    }

    public static void opt(SqlOpSelectBlock op) {
    }

    public static <T> Map<T, T> transitiveMapInPlace(Map<T, T> map) {
        Map<T, T> open = map;
        Map<T, T> next = new HashMap<T, T>();
        while (true) {
            for (Map.Entry<T, T> edge : open.entrySet()) {
                T nodeA = edge.getKey();
                T nodeB = edge.getValue();
                T nodeC = map.get(nodeB);
                if (nodeC == null) continue;
                next.put(nodeA, nodeC);
            }
            if (next.isEmpty()) {
                return map;
            }
            map.putAll(next);
            if (open == map) {
                open = new HashMap<T, T>();
            } else {
                open.clear();
            }
            HashMap<T, T> tmp = next;
            next = open;
            open = tmp;
        }
    }

    public SelfJoinResult eliminateSelfJoins(List<SqlOp> ops, List<Collection<SqlExpr>> cnf) {
        HashMap<String, SqlOpLeaf> aliasToTable = new HashMap<String, SqlOpLeaf>();
        HashMultimap nameToTable = HashMultimap.create();
        ArrayList<SqlOp> rests = new ArrayList<SqlOp>();
        for (SqlOp op : ops) {
            if (op instanceof SqlOpLeaf) {
                SqlOpLeaf opTable = (SqlOpLeaf)op;
                String tableName = opTable.getId();
                nameToTable.put((Object)tableName, (Object)opTable);
                String aliasName = opTable.getAliasName();
                aliasToTable.put(aliasName, opTable);
                continue;
            }
            rests.add(op);
        }
        SimpleGraph selfJoinGraph = new SimpleGraph(EdgeSelfJoin.class);
        HashMap cToTblToColsToAliases = new HashMap();
        for (Collection<SqlExpr> clause : cnf) {
            String aliasB;
            SqlOpLeaf tableB;
            String tableNameB;
            S_ColumnRef b;
            String colNameB;
            SqlExpr expr;
            if (clause.size() != 1 || !((expr = clause.iterator().next()) instanceof S_Equals)) continue;
            S_Equals equals = (S_Equals)expr;
            SqlExpr ta = equals.getLeft();
            SqlExpr tb = equals.getRight();
            if (!(ta instanceof S_ColumnRef)) {
                SqlExpr tmp = ta;
                ta = tb;
                tb = tmp;
            }
            if (!(ta instanceof S_ColumnRef)) continue;
            S_ColumnRef a = (S_ColumnRef)ta;
            String colNameA = a.getColumnName();
            String aliasA = a.getRelationAlias();
            SqlOpLeaf tableA = (SqlOpLeaf)aliasToTable.get(aliasA);
            String tableNameA = tableA.getId();
            if (tb instanceof S_Constant) {
                Multimap colsToAliases;
                S_Constant constant = (S_Constant)tb;
                HashMap<String, Multimap> tblToColsToAliases = (HashMap<String, Multimap>)cToTblToColsToAliases.get(constant);
                if (tblToColsToAliases == null) {
                    tblToColsToAliases = new HashMap<String, Multimap>();
                    cToTblToColsToAliases.put(constant, tblToColsToAliases);
                }
                if ((colsToAliases = (Multimap)tblToColsToAliases.get(tableNameA)) == null) {
                    colsToAliases = HashMultimap.create();
                    tblToColsToAliases.put(tableNameA, colsToAliases);
                }
                Collection aliases = colsToAliases.get((Object)colNameA);
                aliases.add(aliasA);
                continue;
            }
            if (!(tb instanceof S_ColumnRef) || !colNameA.equals(colNameB = (b = (S_ColumnRef)tb).getColumnName()) || !tableNameA.equals(tableNameB = (tableB = (SqlOpLeaf)aliasToTable.get(aliasB = b.getRelationAlias())).getId())) continue;
            selfJoinGraph.addVertex((Object)aliasA);
            selfJoinGraph.addVertex((Object)aliasB);
            EdgeSelfJoin edge = (EdgeSelfJoin)((Object)selfJoinGraph.getEdge((Object)aliasA, (Object)aliasB));
            if (edge == null) {
                edge = new EdgeSelfJoin(aliasA, aliasB);
                selfJoinGraph.addEdge((Object)aliasA, (Object)aliasB, (Object)edge);
            }
            edge.getColumnNames().add(colNameA);
        }
        boolean enableConstantSelfJoinElimination = true;
        if (enableConstantSelfJoinElimination) {
            for (Map tblToColsToAliases : cToTblToColsToAliases.values()) {
                for (Multimap colsToAliases : tblToColsToAliases.values()) {
                    for (Map.Entry entry : colsToAliases.asMap().entrySet()) {
                        String colName = (String)entry.getKey();
                        ArrayList aliases = new ArrayList((Collection)entry.getValue());
                        for (String alias : aliases) {
                            selfJoinGraph.addVertex((Object)alias);
                        }
                        for (int i = 0; i < aliases.size() - 1; ++i) {
                            String aliasA = (String)aliases.get(i);
                            for (int j = i + 1; j < aliases.size(); ++j) {
                                String aliasB = (String)aliases.get(j);
                                EdgeSelfJoin edge = (EdgeSelfJoin)((Object)selfJoinGraph.getEdge((Object)aliasA, (Object)aliasB));
                                if (edge == null) {
                                    edge = new EdgeSelfJoin(aliasA, aliasB);
                                    selfJoinGraph.addEdge((Object)aliasA, (Object)aliasB, (Object)edge);
                                }
                                edge.getColumnNames().add(colName);
                            }
                        }
                    }
                }
            }
        }
        ArrayList openEdges = new ArrayList(selfJoinGraph.edgeSet());
        ArrayList<EdgeSelfJoin> nextEdges = new ArrayList<EdgeSelfJoin>();
        HashMap<String, String> aliasRemap = new HashMap<String, String>();
        while (!openEdges.isEmpty()) {
            for (EdgeSelfJoin edge : openEdges) {
                Index index;
                ColumnsReference ref;
                List indexCols;
                boolean isRemapped;
                String aliasA = edge.getAliasA();
                String aliasB = edge.getAliasB();
                boolean isRemappedA = aliasRemap.containsKey(aliasA);
                boolean isRemappedB = aliasRemap.containsKey(aliasB);
                boolean bl = isRemapped = isRemappedA || isRemappedB;
                if (isRemapped) continue;
                SqlOpLeaf tableA = (SqlOpLeaf)aliasToTable.get(aliasA);
                String tableName = tableA.getId();
                Set<String> joinColumns = edge.getColumnNames();
                Multimap tableToIndexes = this.dbSchema.getIndexes();
                Collection indexes = tableToIndexes.get((Object)tableName);
                boolean isSelfJoin = false;
                Iterator i$ = indexes.iterator();
                while (i$.hasNext() && !(isSelfJoin = joinColumns.containsAll(indexCols = (ref = (index = (Index)i$.next()).getColumns()).getColumnNames()))) {
                }
                if (!isSelfJoin) continue;
                aliasRemap.put(aliasB, aliasA);
                Set edges = selfJoinGraph.edgesOf((Object)aliasB);
                for (EdgeSelfJoin e : edges) {
                    String mergeAlias = e.getAliasB().equals(aliasB) ? e.getAliasA() : e.getAliasB();
                    if (!aliasB.equals(mergeAlias)) continue;
                    EdgeSelfJoin update = (EdgeSelfJoin)((Object)selfJoinGraph.getEdge((Object)aliasB, (Object)mergeAlias));
                    if (update == null) {
                        update = (EdgeSelfJoin)((Object)selfJoinGraph.addEdge((Object)aliasA, (Object)mergeAlias));
                    }
                    nextEdges.add(update);
                    update.getColumnNames().addAll(e.getColumnNames());
                }
                selfJoinGraph.removeVertex((Object)aliasB);
            }
            openEdges.clear();
            ArrayList<EdgeSelfJoin> tmp = nextEdges;
            nextEdges = openEdges;
            openEdges = tmp;
        }
        SqlOptimizerImpl.transitiveMapInPlace(aliasRemap);
        AliasSubstitutor aliasSubstitutor = new AliasSubstitutor(aliasRemap);
        ArrayList<SqlOp> newOps = new ArrayList<SqlOp>();
        for (SqlOpLeaf table : aliasToTable.values()) {
            String alias = table.getAliasName();
            boolean isRemapped = aliasRemap.containsKey(alias);
            if (isRemapped) continue;
            newOps.add(table);
        }
        newOps.addAll(rests);
        SelfJoinResult result = new SelfJoinResult(newOps, aliasSubstitutor);
        return result;
    }

    public static OptResult opt(SqlOp op, Set<S_ColumnRef> references) {
        return null;
    }

    public OptResult opt(SqlOpSelectBlock op, Set<S_ColumnRef> references) {
        List<Collection<SqlExpr>> cnf = SqlExprUtils.toCnf(op.getConditions());
        SqlExprUtils.optimizeNotNullInPlace(cnf);
        SqlOp subOp = op.getSubOp();
        List<SqlOp> subOps = SqlOptimizerImpl.collectJoins(subOp);
        this.eliminateSelfJoins(subOps, cnf);
        if (subOps.size() > 1) {
            for (SqlOp s : subOps) {
            }
        }
        return null;
    }

    public static void substituteProjectionInPlace(Projection proj, Factory1<SqlExpr> transformer) {
        for (Map.Entry<String, SqlExpr> entry : proj.getNameToExpr().entrySet()) {
            SqlExpr expr = entry.getValue();
            SqlExpr newExpr = SqlExprSubstitutor2.substitute(expr, transformer);
            entry.setValue(newExpr);
        }
    }

    public static List<SqlSortCondition> transformSortConditions(List<SqlSortCondition> sortConditions, Factory1<SqlExpr> transformer) {
        ArrayList<SqlSortCondition> result = new ArrayList<SqlSortCondition>(sortConditions.size());
        for (SqlSortCondition sc : sortConditions) {
            int direction = sc.getDirection();
            SqlExpr expr = sc.getExpression();
            SqlExpr newExpr = SqlExprSubstitutor2.substitute(expr, transformer);
            SqlSortCondition newSc = new SqlSortCondition(newExpr, direction);
            result.add(newSc);
        }
        return result;
    }

    public void optimize(SqlOp op) {
        block4: {
            block3: {
                if (!(op instanceof SqlOpSelectBlock)) break block3;
                SqlOpSelectBlock block = (SqlOpSelectBlock)op;
                List<Collection<SqlExpr>> cnf = SqlExprUtils.toCnf(block.getConditions());
                SqlExprUtils.optimizeNotNullInPlace(cnf);
                SqlOp subOp = block.getSubOp();
                List<SqlOp> subOps = SqlOptimizerImpl.collectJoins(subOp);
                for (SqlOp so : subOps) {
                    this.optimize(so);
                }
                SelfJoinResult sjr = this.eliminateSelfJoins(subOps, cnf);
                List<SqlOp> newOps = sjr.getOps();
                Factory1<SqlExpr> aliasRemapper = sjr.getAliasSubstitutor();
                List<Collection<SqlExpr>> newCnf = SqlExprSubstitutor2.substitute(cnf, aliasRemapper);
                SqlExprUtils.optimizeEqualityInPlace(newCnf);
                List<SqlExpr> exprs = SqlExprUtils.cnfAsList(newCnf);
                block.getConditions().clear();
                block.getConditions().addAll(exprs);
                SqlOptimizerImpl.substituteProjectionInPlace(block.getProjection(), aliasRemapper);
                List<SqlSortCondition> newSortConditions = SqlOptimizerImpl.transformSortConditions(block.getSortConditions(), aliasRemapper);
                block.getSortConditions().clear();
                block.getSortConditions().addAll(newSortConditions);
                SqlOp newOp = newOps.size() > 1 ? new SqlOpJoinN(null, newOps) : newOps.get(0);
                block.setSubOp(newOp);
                if (subOps.size() <= 1) break block4;
                for (SqlOp s : subOps) {
                }
                break block4;
            }
            List<SqlOp> subOps = op.getSubOps();
            for (SqlOp subOp : subOps) {
                this.optimize(subOp);
            }
        }
    }

    public static List<SqlOp> collectJoins(SqlOp sqlOp) {
        ArrayList<SqlOp> result = new ArrayList<SqlOp>();
        SqlOptimizerImpl.collectJoins(sqlOp, result);
        return result;
    }

    public static void collectJoins(SqlOp sqlOp, List<SqlOp> result) {
        SqlOpJoin opJoin;
        if (sqlOp instanceof SqlOpJoin && (opJoin = (SqlOpJoin)sqlOp).getJoinType().equals((Object)JoinType.INNER)) {
            SqlOp a = opJoin.getLeft();
            SqlOp b = opJoin.getRight();
            SqlOptimizerImpl.collectJoins(a, result);
            SqlOptimizerImpl.collectJoins(b, result);
            return;
        }
        result.add(sqlOp);
    }

    class OptResult {
        private SqlOp op;
        private Map<S_ColumnRef, S_ColumnRef> replacement;

        public OptResult(SqlOp op, Map<S_ColumnRef, S_ColumnRef> replacement) {
            this.op = op;
            this.replacement = replacement;
        }

        public SqlOp getOp() {
            return this.op;
        }

        public Map<S_ColumnRef, S_ColumnRef> getReplacement() {
            return this.replacement;
        }

        public String toString() {
            return "OptiStep [op=" + this.op + ", replacement=" + this.replacement + "]";
        }
    }
}

