/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.sparqlify.core.algorithms.MappingOpsImpl;
import org.aksw.sparqlify.core.algorithms.OpMapping;
import org.aksw.sparqlify.core.algorithms.OpViewInstanceJoin;
import org.aksw.sparqlify.core.algorithms.Ops;
import org.aksw.sparqlify.core.algorithms.ViewInstance;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.MappingOps;
import org.aksw.sparqlify.core.interfaces.OpMappingRewriter;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpMappingRewriterImpl
implements OpMappingRewriter {
    private static final Logger logger = LoggerFactory.getLogger(OpMappingRewriterImpl.class);
    private MappingOps ops;

    public OpMappingRewriterImpl(MappingOps ops) {
        this.ops = ops;
    }

    public MappingOps getMappingOps() {
        return this.ops;
    }

    public Mapping rewrite(OpViewInstanceJoin op) {
        Collection vis = op.getJoin().getViewInstances();
        Mapping result = null;
        for (ViewInstance<ViewDefinition> viewInstance : vis) {
            Mapping tmp = this.ops.createMapping(viewInstance);
            if (result == null) {
                result = tmp;
                continue;
            }
            result = this.ops.join(result, tmp);
        }
        return result;
    }

    public List<Mapping> rewriteList(List<Op> ops) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>(ops.size());
        for (Op op : ops) {
            Mapping tmp = this.rewrite(op);
            mappings.add(tmp);
        }
        return mappings;
    }

    public Mapping rewrite(OpDisjunction op) {
        List elements = op.getElements();
        List<Mapping> mappings = this.rewriteList(elements);
        Mapping result = this.ops.union(mappings);
        return result;
    }

    public Mapping rewrite(OpSequence op) {
        List members = op.getElements();
        if (members.isEmpty()) {
            MappingOpsImpl.createEmptyMapping();
        }
        Mapping a = null;
        for (Op member : members) {
            Mapping b = this.rewrite(member);
            if (a == null) {
                a = b;
                continue;
            }
            a = this.ops.join(a, b);
        }
        return a;
    }

    public Mapping join(Op a, Op b) {
        Mapping ma = this.rewrite(a);
        Mapping mb = this.rewrite(b);
        Mapping result = this.ops.join(ma, mb);
        return result;
    }

    public Mapping rewrite(OpJoin op) {
        Mapping result = this.join(op.getLeft(), op.getRight());
        return result;
    }

    public Mapping rewrite(OpLeftJoin op) {
        Mapping a = this.rewrite(op.getLeft());
        Mapping b = this.rewrite(op.getRight());
        Mapping result = this.ops.leftJoin(a, b);
        return result;
    }

    public Mapping rewrite(OpConditional op) {
        OpLeftJoin tmp = (OpLeftJoin)OpLeftJoin.create((Op)op.getLeft(), (Op)op.getRight(), (ExprList)new ExprList());
        Mapping result = this.rewrite(tmp);
        return result;
    }

    public Mapping rewrite(OpFilterIndexed op) {
        Mapping a = this.rewrite(op.getSubOp());
        Mapping result = this.ops.filter(a, op.getRestrictions().getExprs());
        return result;
    }

    public Mapping rewrite(OpSlice op) {
        Mapping a = this.rewrite(op.getSubOp());
        Long limit = op.getLength() == Long.MIN_VALUE ? null : Long.valueOf(op.getLength());
        Long offset = op.getStart() == Long.MIN_VALUE ? null : Long.valueOf(op.getStart());
        Mapping result = this.ops.slice(a, limit, offset);
        return result;
    }

    public Mapping rewrite(OpAssign op) {
        OpExtend tmp = (OpExtend)OpExtend.extend((Op)op.getSubOp(), (VarExprList)op.getVarExprList());
        Mapping result = this.rewrite(tmp);
        return result;
    }

    public Mapping rewrite(OpExtend op) {
        Mapping a = this.rewrite(op.getSubOp());
        logger.warn("OpExtend: We need to check whether term constructors must be injected");
        VarDefinition varDef = VarDefinition.create(op.getVarExprList());
        Mapping result = this.ops.extend(a, varDef);
        return result;
    }

    public Mapping rewrite(OpProject op) {
        Mapping a = this.rewrite(op.getSubOp());
        Mapping result = this.ops.project(a, op.getVars());
        return result;
    }

    public Mapping rewrite(OpDistinct op) {
        Mapping a = this.rewrite(op.getSubOp());
        Mapping result = this.ops.distinct(a);
        return result;
    }

    public Mapping rewrite(OpOrder op) {
        Mapping a = this.rewrite(op.getSubOp());
        List sortConditions = op.getConditions();
        Mapping result = this.ops.order(a, sortConditions);
        return result;
    }

    public Mapping rewrite(OpGroup op) {
        Mapping a = this.rewrite(op.getSubOp());
        Mapping result = this.ops.groupBy(a, op.getGroupVars(), op.getAggregators());
        return result;
    }

    public Mapping rewrite(OpTopN op) {
        Op sub = op.getSubOp();
        OpOrder inner = new OpOrder(sub, op.getConditions());
        OpSlice outer = new OpSlice((Op)inner, 0L, (long)op.getLimit());
        Mapping result = this.rewrite(outer);
        return result;
    }

    public Mapping rewrite(OpMapping op) {
        Mapping result = op.getMapping();
        return result;
    }

    @Override
    public Mapping rewrite(Op op) {
        Mapping result;
        Ops type = Ops.valueOf(op.getClass().getSimpleName());
        switch (type) {
            case OpOrder: {
                result = this.rewrite((OpOrder)op);
                break;
            }
            case OpDistinct: {
                result = this.rewrite((OpDistinct)op);
                break;
            }
            case OpFilter: {
                result = this.rewrite((Op)((OpFilter)op));
                break;
            }
            case OpGroup: {
                result = this.rewrite((OpGroup)op);
                break;
            }
            case OpJoin: {
                result = this.rewrite((OpJoin)op);
                break;
            }
            case OpLeftJoin: {
                result = this.rewrite((OpLeftJoin)op);
                break;
            }
            case OpExtend: {
                result = this.rewrite((OpExtend)op);
                break;
            }
            case OpQuadPattern: {
                result = this.rewrite((Op)((OpQuadPattern)op));
                break;
            }
            case OpSlice: {
                result = this.rewrite((OpSlice)op);
                break;
            }
            case OpProject: {
                result = this.rewrite((OpProject)op);
                break;
            }
            case OpFilterIndexed: {
                result = this.rewrite((OpFilterIndexed)op);
                break;
            }
            case OpMapping: {
                result = this.rewrite((OpMapping)op);
                break;
            }
            case OpUnion: {
                result = this.rewrite((Op)((OpUnion)op));
                break;
            }
            case OpDisjunction: {
                result = this.rewrite((OpDisjunction)op);
                break;
            }
            case OpViewInstanceJoin: {
                result = this.rewrite((OpViewInstanceJoin)op);
                break;
            }
            default: {
                throw new RuntimeException("Unknown op type: " + op.getClass());
            }
        }
        return result;
    }
}

