/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.List;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.core.OpQuadPattern2;

public class ReplaceConstants {
    private static Generator generator = Gensym.create((String)"var", (int)0);

    public static Triple listToTriple(List<Node> nodes) {
        return new Triple(nodes.get(0), nodes.get(1), nodes.get(2));
    }

    public static Quad listToQuad(List<Node> nodes) {
        return new Quad(nodes.get(0), nodes.get(1), nodes.get(2), nodes.get(3));
    }

    public static List<Node> tripleToList(Triple triple) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(triple.getSubject());
        result.add(triple.getPredicate());
        result.add(triple.getObject());
        return result;
    }

    public static Op replace(Op op) {
        return (Op)MultiMethod.invokeStatic(ReplaceConstants.class, (String)"_replace", (Object[])new Object[]{op});
    }

    public static Node transform(Node node, Generator generator, ExprList filters) {
        if (node.isConcrete()) {
            Var var = Var.alloc((String)generator.next());
            E_Equals condition = new E_Equals((Expr)new ExprVar(var), (Expr)NodeValue.makeNode((Node)node));
            filters.add((Expr)condition);
            return var;
        }
        return node;
    }

    public static Op _replace(OpGroup op) {
        return new OpGroup(ReplaceConstants.replace(op.getSubOp()), op.getGroupVars(), op.getAggregators());
    }

    public static Op _replace(OpTable op) {
        return null;
    }

    public static Op _replace(OpExtend op) {
        return OpExtend.extend((Op)ReplaceConstants.replace(op.getSubOp()), (VarExprList)op.getVarExprList());
    }

    public static Op _replace(OpAssign op) {
        Op newSubOp = ReplaceConstants.replace(op.getSubOp());
        Op result = OpExtend.extend((Op)newSubOp, (VarExprList)op.getVarExprList());
        return result;
    }

    public static Op _replace(OpSlice op) {
        return new OpSlice(ReplaceConstants.replace(op.getSubOp()), op.getStart(), op.getLength());
    }

    public static Op _replace(OpOrder op) {
        return new OpOrder(ReplaceConstants.replace(op.getSubOp()), op.getConditions());
    }

    public static Op _replace(OpProject op) {
        return new OpProject(ReplaceConstants.replace(op.getSubOp()), op.getVars());
    }

    public static Op _replace(OpTopN op) {
        return new OpTopN(ReplaceConstants.replace(op.getSubOp()), op.getLimit(), op.getConditions());
    }

    public static Op _replace(OpDistinct op) {
        return new OpDistinct(ReplaceConstants.replace(op.getSubOp()));
    }

    public static Op _replace(OpLeftJoin op) {
        return OpLeftJoin.create((Op)ReplaceConstants.replace(op.getLeft()), (Op)ReplaceConstants.replace(op.getRight()), (ExprList)op.getExprs());
    }

    public static Op _replace(OpSequence op) {
        List members = op.getElements();
        ArrayList<Op> newMembers = new ArrayList<Op>(members.size());
        for (Op member : members) {
            Op newMember = ReplaceConstants.replace(member);
            newMembers.add(newMember);
        }
        OpN result = OpSequence.create().copy(newMembers);
        return result;
    }

    public static Op _replace(OpConditional op) {
        Op newLeft = ReplaceConstants.replace(op.getLeft());
        Op newRight = ReplaceConstants.replace(op.getRight());
        OpConditional result = new OpConditional(newLeft, newRight);
        return result;
    }

    public static Op _replace(OpJoin op) {
        return OpJoin.create((Op)ReplaceConstants.replace(op.getLeft()), (Op)ReplaceConstants.replace(op.getRight()));
    }

    public static Op _replace(OpUnion op) {
        return OpUnion.create((Op)ReplaceConstants.replace(op.getLeft()), (Op)ReplaceConstants.replace(op.getRight()));
    }

    public static Op _replace(OpDisjunction op) {
        OpDisjunction result = OpDisjunction.create();
        for (Op member : op.getElements()) {
            Op newMember = ReplaceConstants.replace(member);
            result.add(newMember);
        }
        return result;
    }

    public static Op _replace(OpFilter op) {
        return OpFilter.filter((ExprList)op.getExprs(), (Op)ReplaceConstants.replace(op.getSubOp()));
    }

    public static Op _replace(OpQuadPattern op) {
        ExprList filters = new ExprList();
        QuadPattern quadPattern = new QuadPattern();
        Node rawGraphNode = op.getGraphNode();
        Node commonGraphNode = null;
        if (rawGraphNode.isConcrete()) {
            if (!rawGraphNode.equals((Object)Quad.defaultGraphNodeGenerated)) {
                commonGraphNode = ReplaceConstants.transform(rawGraphNode, generator, filters);
            }
        } else {
            commonGraphNode = rawGraphNode;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(4);
        for (Triple triple : op.getBasicPattern().getList()) {
            Object graphNode = commonGraphNode != null ? commonGraphNode : Var.alloc((String)generator.next());
            nodes.add((Node)graphNode);
            for (Node node : ReplaceConstants.tripleToList(triple)) {
                Node n = ReplaceConstants.transform(node, generator, filters);
                nodes.add(n);
            }
            Quad q = ReplaceConstants.listToQuad(nodes);
            quadPattern.add(q);
            nodes.clear();
        }
        OpQuadPattern2 result = new OpQuadPattern2(quadPattern);
        if (!filters.isEmpty()) {
            result = OpFilter.filter((ExprList)filters, (Op)result);
        }
        return result;
    }
}

