/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.karneim.util.collection.regex.PatternPro;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.config.lang.Constraint;
import org.aksw.sparqlify.config.lang.PrefixConstraint;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.config.lang.RegexConstraint;
import org.aksw.sparqlify.core.RdfTermPattern;
import org.aksw.sparqlify.database.StartsWithConstraint;

public class ConstraintContainer {
    private Map<Var, RdfTermPattern> varRegexConstraints = new HashMap<Var, RdfTermPattern>();
    private Map<Var, PrefixSet> varPrefixConstraints = new HashMap<Var, PrefixSet>();

    public Map<Var, RdfTermPattern> getVarPatternConstraints() {
        return this.varRegexConstraints;
    }

    public Map<Var, PrefixSet> getVarPrefixConstraints() {
        return this.varPrefixConstraints;
    }

    public ConstraintContainer() {
    }

    public ConstraintContainer(List<Constraint> constraints) {
        this.addAll(constraints);
    }

    public RdfTermPattern getPattern(Var var) {
        return this.varRegexConstraints.get(var);
    }

    public void addAll(List<Constraint> constraints) {
        for (Constraint c : constraints) {
            MultiMethod.invoke((Object)this, (String)"add", (Object[])new Object[]{c});
        }
    }

    public ConstraintContainer(Map<Var, RdfTermPattern> varRegexConstraints) {
        this.varRegexConstraints = varRegexConstraints;
    }

    public ConstraintContainer(Map<Var, RdfTermPattern> varRegexConstraints, Map<Var, PrefixSet> varPrefixConstraints) {
        this.varRegexConstraints = varRegexConstraints;
        this.varPrefixConstraints = varPrefixConstraints;
    }

    public static <K, V> Map<K, V> copy(Map<K, V> a, Map<? super K, ? super K> renamer) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> e : a.entrySet()) {
            K sub;
            K var = e.getKey();
            if (renamer != null && (sub = renamer.get(var)) != null) {
                var = sub;
            }
            result.put(var, e.getValue());
        }
        return result;
    }

    public void add(Var var, StartsWithConstraint constraint) {
        PrefixSet prefixes = this.varPrefixConstraints.get(var);
        if (prefixes == null) {
            prefixes = new PrefixSet();
            this.varPrefixConstraints.put(var, prefixes);
        }
        prefixes.addAll(Collections.singleton(constraint.getPrefix()));
    }

    @Deprecated
    public void add(PrefixConstraint constraint) {
        PrefixSet prefixes = this.varPrefixConstraints.get(constraint.getVar());
        if (prefixes == null) {
            prefixes = new PrefixSet();
            this.varPrefixConstraints.put(constraint.getVar(), prefixes);
        }
        prefixes.addAll(constraint.getPrefixes());
    }

    public void add(RegexConstraint constraint) {
        RdfTermPattern map = this.varRegexConstraints.get(constraint.getVar());
        if (map == null) {
            map = new RdfTermPattern();
            this.varRegexConstraints.put(constraint.getVar(), map);
        }
        if (constraint.getAttribute().equals("value")) {
            map.setValue(RegexConstraint.intersect((PatternPro)map.getValue(), constraint.getPattern()));
        } else if (constraint.getAttribute().equals("datatype")) {
            map.setDatatype(RegexConstraint.intersect(map.getDatatype(), constraint.getPattern()));
        } else {
            throw new RuntimeException("Should not happen; Unknown attribute '" + constraint.getAttribute() + "'");
        }
    }

    public ConstraintContainer copySubstitute(Map<Node, Node> renamer) {
        return new ConstraintContainer(ConstraintContainer.copy(this.varRegexConstraints, renamer), ConstraintContainer.copy(this.varPrefixConstraints, renamer));
    }
}

