/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.config.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.VarDef;
import org.aksw.sparqlify.config.lang.Constraint;
import org.aksw.sparqlify.config.syntax.QueryString;
import org.aksw.sparqlify.config.syntax.RelationRef;
import org.aksw.sparqlify.config.syntax.ViewTemplateDefinition;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.system.PrefixMap;

public class ViewDefinition {
    private String name;
    private ViewTemplateDefinition viewTemplateDefinition;
    private ExprList filters = new ExprList();
    private SqlOp relation;
    private List<Constraint> constraints;

    public ViewDefinition() {
        this.viewTemplateDefinition = new ViewTemplateDefinition();
    }

    public ViewDefinition(String name, ViewTemplateDefinition viewTemplateDefinition, SqlOp relation, List<Constraint> constraints) {
        this.name = name;
        this.viewTemplateDefinition = viewTemplateDefinition;
        this.relation = relation;
        this.constraints = constraints;
    }

    public ViewTemplateDefinition getViewTemplateDefinition() {
        return this.viewTemplateDefinition;
    }

    public void setViewTemplateDefinition(ViewTemplateDefinition viewTemplateDefinition) {
        this.viewTemplateDefinition = viewTemplateDefinition;
    }

    public void setConstructTemplate(ViewTemplateDefinition viewTemplateDefinition) {
        this.viewTemplateDefinition = viewTemplateDefinition;
    }

    public String getName() {
        return this.name;
    }

    public SqlOp getRelation() {
        return this.relation;
    }

    public void setRelation(SqlOp relation) {
        this.relation = relation;
    }

    public ExprList getFilters() {
        return this.filters;
    }

    public void setFilters(ExprList filters) {
        this.filters = filters;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public String toString() {
        return "ViewDefinition [constructTemplate=" + this.viewTemplateDefinition + ", relation=" + this.relation + "]";
    }

    public String getDefinitionString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IndentedWriter out = new IndentedWriter((OutputStream)baos);
        out.print("Create View ");
        out.print(this.getName());
        out.println(" As");
        out.incIndent();
        out.println("Construct {");
        out.incIndent();
        QuadPattern template = this.getViewTemplateDefinition().getConstructTemplate();
        Map map = QuadPatternUtils.indexSorted((Iterable)template);
        for (Map.Entry entry : map.entrySet()) {
            Node g = (Node)entry.getKey();
            Set triples = (Set)entry.getValue();
            boolean isDefaultGraph = Quad.defaultGraphNodeGenerated.equals((Object)g);
            if (!isDefaultGraph) {
                out.println("GRAPH " + g + " {");
                out.incIndent();
            }
            for (Triple triple : triples) {
                String triplesStr = ViewDefinition.toNTripleString(triple, null);
                out.println(triplesStr);
            }
            if (isDefaultGraph) continue;
            out.decIndent();
            out.println("}");
        }
        out.decIndent();
        out.println("}");
        out.println("With");
        out.incIndent();
        for (Expr expr : this.getViewTemplateDefinition().getVarBindings()) {
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Should not happen.");
            }
            E_Equals e = (E_Equals)expr;
            out.println(e.getArg1() + " = " + ExprUtils.fmtSPARQL((Expr)e.getArg2()));
        }
        out.decIndent();
        out.println("From");
        out.incIndent();
        if (this.relation instanceof QueryString) {
            out.println("[[" + ((QueryString)((Object)this.relation)).getQueryString() + "]]");
        } else if (this.relation instanceof RelationRef) {
            out.println(((RelationRef)((Object)this.relation)).getRelationName());
        } else {
            throw new RuntimeException("Should not happen");
        }
        out.decIndent();
        out.decIndent();
        out.flush();
        out.close();
        return baos.toString();
    }

    public static String toNTripleString(Triple triple, PrefixMap map) {
        return ViewDefinition.toNTripleString(triple.getSubject(), map) + " " + ViewDefinition.toNTripleString(triple.getPredicate(), map) + " " + ViewDefinition.toNTripleString(triple.getObject(), map) + " .";
    }

    public static String toNTripleString(Node node, PrefixMap map) {
        if (node.isURI()) {
            String result = null;
            if (map != null) {
                result = map.abbreviate(node.getURI());
            }
            if (result == null) {
                return "<" + node.getURI() + ">";
            }
            return result;
        }
        return node.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addVarDef(Var var, VarDef termDef) {
        this.addVarDef(var, termDef.getExpr());
    }

    public void addVarDef(Var var, Expr expr) {
        E_Equals tmp = new E_Equals((Expr)new ExprVar(var), expr);
        this.viewTemplateDefinition.getVarBindings().add((Expr)tmp);
    }

    public QuadPattern getConstructPattern() {
        return this.viewTemplateDefinition.getConstructTemplate();
    }
}

