/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_IsIRI;
import com.hp.hpl.jena.sparql.expr.E_Lang;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCount;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDT;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.expr.old.ExprSqlBridge;
import org.aksw.sparqlify.algebra.sparql.expr.old.NodeValueGeom;
import org.aksw.sparqlify.algebra.sql.exprs.SqlAggregator;
import org.aksw.sparqlify.algebra.sql.exprs.SqlAggregatorCount;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprAggregator;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprList;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.compile.sparql.ExprPusher;
import org.aksw.sparqlify.compile.sparql.ExprPusherConcat;
import org.aksw.sparqlify.compile.sparql.SqlPrePusher;
import org.aksw.sparqlify.compile.sparql.SqlPusher;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.trash.ExprArgs;
import org.aksw.sparqlify.trash.ExprCopy;
import org.postgis.PGgeometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDown {
    public static final Logger logger = LoggerFactory.getLogger(PushDown.class);
    public static final Map<String, ExprPusher> userFuncToPusher = new HashMap<String, ExprPusher>();

    public static Expr pushDownMM(Expr expr) {
        return (Expr)MultiMethod.invokeStatic(PushDown.class, (String)"pushDown", (Object[])new Object[]{expr});
    }

    public static ExprList pushDownArgs(Iterable<Expr> exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            Expr tmp = PushDown.pushDownMM(expr);
            result.add(tmp);
        }
        return result;
    }

    public static Expr pushDown(Expr expr) {
        return expr;
    }

    public static Expr pushDown(ExprAggregator expr) {
        SqlAggregator sqlAggregator = PushDown._pushDownAgg(expr.getAggregator());
        ExprSqlBridge result = new ExprSqlBridge(new SqlExprAggregator(expr.getVar().getName(), sqlAggregator));
        return result;
    }

    public static SqlAggregator _pushDownAgg(Aggregator agg) {
        SqlAggregator result = (SqlAggregator)MultiMethod.invokeStatic(PushDown.class, (String)"pushDownAgg", (Object[])new Object[]{agg});
        return result;
    }

    public static SqlAggregatorCount pushDownAgg(AggCount agg) {
        return new SqlAggregatorCount();
    }

    public static Expr pushDown(E_Lang expr) {
        return PushDown.pushDownMM(SqlPrePusher.asRdfTerm(expr.getArg()).getLanguageTag());
    }

    public static Expr pushDown(ExprSqlBridge expr) {
        return expr;
    }

    public static SqlExprList extractSqlExprs(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr != null && expr instanceof ExprSqlBridge) continue;
            return null;
        }
        SqlExprList result = new SqlExprList();
        for (Expr expr : exprs) {
            SqlExpr arg = ((ExprSqlBridge)expr).getSqlExpr();
            if (arg == null) {
                throw new RuntimeException("Null expression. Should not happen");
            }
            result.add(arg);
        }
        return result;
    }

    public static Expr pushDown(NodeValue expr) {
        try {
            return PushDown.pushDownE(expr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Expr pushDownE(NodeValue expr) throws Exception {
        SqlExprValue result = null;
        if (expr.isIRI()) {
            result = new SqlExprValue(expr.asNode().getURI());
            logger.debug("HACK - Uri constants should be converted to RdfTerms first");
        } else if (expr.isBoolean()) {
            result = new SqlExprValue(expr.getBoolean());
        } else if (expr.isNumber()) {
            BigDecimal d;
            result = expr.isDecimal() ? ((d = expr.getDecimal()).scale() > 0 ? new SqlExprValue(d.doubleValue()) : new SqlExprValue(d.intValue())) : (expr.isDouble() ? new SqlExprValue(expr.getDouble()) : (expr.isFloat() ? new SqlExprValue(Float.valueOf(expr.getFloat())) : new SqlExprValue(expr.getDecimal().longValue())));
        } else if (expr.isString()) {
            result = new SqlExprValue(expr.getString());
        } else if (expr instanceof NodeValueDT) {
            result = new SqlExprValue(expr.getDateTime().toGregorianCalendar());
        } else if (expr instanceof NodeValueGeom) {
            result = new SqlExprValue(((NodeValueGeom)expr).getGeometry());
        } else if (expr.isLiteral()) {
            Node node = expr.asNode();
            if (node.getLiteralDatatypeURI().equals("http://www.opengis.net/ont/geosparql#wktLiteral")) {
                result = new SqlExprValue(new PGgeometry(node.getLiteralLexicalForm()), DatatypeSystemDefault._GEOMETRY);
            }
        } else {
            throw new RuntimeException("Unknow datatype of constant: " + expr.getClass() + " ," + expr);
        }
        return new ExprSqlBridge(result);
    }

    public static Expr pushDown(ExprFunction expr) {
        ExprList args = PushDown.pushDownArgs(expr.getArgs());
        ExprFunction subbed = (ExprFunction)ExprCopy.getInstance().copy((Expr)expr, args);
        Expr applied = SqlPrePusher.prePush(subbed);
        if (applied instanceof ExprSqlBridge) {
            return applied;
        }
        if (applied instanceof E_RdfTerm) {
            return subbed;
        }
        ExprSqlBridge result = null;
        ExprList tmpArgs = ExprArgs.getArgs(applied);
        SqlExprList sqlArgs = PushDown.extractSqlExprs((Iterable<Expr>)tmpArgs);
        if (sqlArgs != null) {
            SqlExpr tmp = (SqlExpr)MultiMethod.invokeStatic(SqlPusher.class, (String)"push", (Object[])new Object[]{applied, sqlArgs});
            result = new ExprSqlBridge(tmp);
        }
        if (result == null) {
            throw new RuntimeException("Should not happen");
        }
        return result;
    }

    public static Expr pushDownOld(ExprFunction expr) {
        Expr simplified = SqlPrePusher.prePush(expr);
        if (!(simplified instanceof ExprFunction)) {
            return PushDown.pushDown(simplified);
        }
        expr = (ExprFunction)simplified;
        if (simplified instanceof ExprSqlBridge) {
            return simplified;
        }
        ExprList args = PushDown.pushDownArgs(expr.getArgs());
        SqlExprList sqlArgs = PushDown.extractSqlExprs((Iterable<Expr>)args);
        Object result = null;
        if (sqlArgs != null) {
            SqlExpr tmp = (SqlExpr)MultiMethod.invokeStatic(SqlPusher.class, (String)"push", (Object[])new Object[]{expr, sqlArgs});
            result = new ExprSqlBridge(tmp);
        }
        if (result == null) {
            result = ExprCopy.getInstance().copy((Expr)expr, args);
        }
        return result;
    }

    public static Expr pushDown(E_IsIRI expr) {
        return PushDown.pushDownMM((Expr)new E_Equals(SqlPrePusher.getTypeOrExpr(expr.getArg()), (Expr)new ExprSqlBridge(new SqlExprValue(1))));
    }

    public static Expr pushDown(E_NotEquals expr) {
        return PushDown.pushDownMM((Expr)new E_LogicalNot((Expr)new E_Equals(expr.getArg1(), expr.getArg2())));
    }

    static {
        userFuncToPusher.put("concat", new ExprPusherConcat());
    }
}

