/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.talis.rdfwriters.json.JSONJenaWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.jena_sparql_api.utils.ModelUtils;
import org.aksw.sparqlify.web.HttpSparqlEndpoint;
import org.aksw.sparqlify.web.Writer;
import org.apache.commons.collections15.Transformer;
import org.apache.jena.riot.out.SinkTripleOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlFormatterUtils {
    public static final Logger logger = LoggerFactory.getLogger(SparqlFormatterUtils.class);
    public static final String FORMAT_XML = "Xml";
    public static final String FORMAT_Text = "Text";
    public static final String FORMAT_Turtle = "Turtle";
    public static final String FORMAT_RdfXml = "RdfXml";
    public static final String FORMAT_Json = "Json";

    public static Model triplesToModel(Iterator<Triple> iterator) {
        Model model = ModelFactory.createDefaultModel();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            Statement stmt = com.hp.hpl.jena.sparql.util.ModelUtils.tripleToStatement((Model)model, (Triple)triple);
            if (stmt == null) {
                logger.warn("Invalid triple detected: " + triple);
                continue;
            }
            model.add(stmt);
        }
        return model;
    }

    public static <I, O> Transformer<I, O> wrapMethod(final Method method) {
        return method == null ? null : new Transformer<I, O>(){

            public O transform(I input) {
                try {
                    return method.invoke(null, input);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Transformer<Model, String> getModelFormatter(String format) {
        Method method = MultiMethod.findMethodByParams(SparqlFormatterUtils.class, (String)("_format" + format), (Class[])new Class[]{Model.class});
        return SparqlFormatterUtils.wrapMethod(method);
    }

    public static Transformer<Boolean, String> getBooleanFormatter(String format) {
        Method method = MultiMethod.findMethodByParams(SparqlFormatterUtils.class, (String)("_format" + format), (Class[])new Class[]{Boolean.class});
        return SparqlFormatterUtils.wrapMethod(method);
    }

    public static Transformer<ResultSet, String> getResultSetFormatter(String format) {
        Method method = MultiMethod.findMethodByParams(SparqlFormatterUtils.class, (String)("_format" + format), (Class[])new Class[]{ResultSet.class});
        return SparqlFormatterUtils.wrapMethod(method);
    }

    public static <T> Writer<T> wrapAsWriter(final Method method) {
        return method == null ? null : new Writer<T>(){

            @Override
            public void write(OutputStream out, T obj) {
                try {
                    method.invoke(null, out, obj);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Writer<Iterator<Triple>> getTripleWriter(String format) {
        Method method = MultiMethod.findMethodByParams(SparqlFormatterUtils.class, (String)("write" + format), (Class[])new Class[]{OutputStream.class, Iterator.class});
        return SparqlFormatterUtils.wrapAsWriter(method);
    }

    public static Writer<Model> getModelWriter(String format) {
        Method method = MultiMethod.findMethodByParams(SparqlFormatterUtils.class, (String)("write" + format), (Class[])new Class[]{OutputStream.class, Model.class});
        return SparqlFormatterUtils.wrapAsWriter(method);
    }

    public static Writer<Boolean> getBooleanWriter(String format) {
        Method method = MultiMethod.findMethodByParams(SparqlFormatterUtils.class, (String)("write" + format), (Class[])new Class[]{OutputStream.class, Boolean.class});
        return SparqlFormatterUtils.wrapAsWriter(method);
    }

    public static Writer<ResultSet> getResultSetWriter(String format) {
        Method method = MultiMethod.findMethodByParams(SparqlFormatterUtils.class, (String)("write" + format), (Class[])new Class[]{OutputStream.class, ResultSet.class});
        return SparqlFormatterUtils.wrapAsWriter(method);
    }

    public static String formatXml(Object o) {
        return (String)MultiMethod.invokeStatic(HttpSparqlEndpoint.class, (String)"_formatXml", (Object[])new Object[]{o});
    }

    public static String _formatXml(Boolean value) {
        String result = "<sparql xmlns='http://www.w3.org/2005/sparql-results#' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.w3.org/2001/sw/DataAccess/rf1/result2.xsd'>\n<head></head>\n<boolean>" + value + "</boolean>" + "</sparql>";
        return result;
    }

    public static String _formatXml(Model model) {
        return SparqlFormatterUtils._formatRdfXml(model);
    }

    public static String _formatRdfXml(Model model) {
        return ModelUtils.toString((Model)model, (String)"RDF/XML");
    }

    public static String _formatXml(ResultSet rs) {
        return ResultSetFormatter.asXMLString((ResultSet)rs);
    }

    public static String _writeXml(OutputStream out, Object o) {
        return (String)MultiMethod.invokeStatic(HttpSparqlEndpoint.class, (String)"writeXml", (Object[])new Object[]{out, o});
    }

    public static void writeXml(OutputStream out, Iterator<Triple> iterator) {
        Model model = SparqlFormatterUtils.triplesToModel(iterator);
        SparqlFormatterUtils.writeXml(out, model);
    }

    public static void writeXml(OutputStream out, Model model) {
        SparqlFormatterUtils.writeRdfXml(out, model);
    }

    public static void writeRdfXml(OutputStream out, Iterator<Triple> iterator) {
        Model model = SparqlFormatterUtils.triplesToModel(iterator);
        SparqlFormatterUtils.writeXml(out, model);
    }

    public static void writeRdfXml(OutputStream out, Model model) {
        model.write(out, "RDF/XML");
    }

    public static void writeXml(OutputStream out, ResultSet rs) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)baos, (ResultSet)rs);
        String str = baos.toString();
        PrintStream ps = new PrintStream(out);
        ps.println(str);
    }

    public static void writeXml(OutputStream out, Boolean value) throws IOException {
        ResultSetFormatter.outputAsXML((OutputStream)out, (boolean)value);
    }

    public static String formatText(Object o) {
        return (String)MultiMethod.invokeStatic(HttpSparqlEndpoint.class, (String)"_formatText", (Object[])new Object[]{o});
    }

    public static String _formatText(Boolean value) {
        String result = "<sparql xmlns='http://www.w3.org/2005/sparql-results#' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.w3.org/2001/sw/DataAccess/rf1/result2.xsd'>\n<head></head>\n<boolean>" + value + "</boolean>" + "</sparql>";
        return result;
    }

    public static String _formatText(Model model) {
        return ModelUtils.toString((Model)model, (String)"N-TRIPLES");
    }

    public static String _formatText(ResultSet rs) {
        return ResultSetFormatter.asText((ResultSet)rs);
    }

    public static void writeText(OutputStream out, Model model) {
        model.write(out, "N-TRIPLES");
    }

    public static void writeText(OutputStream out, Iterator<Triple> it) {
        SinkTripleOutput sink = new SinkTripleOutput(out);
        while (it.hasNext()) {
            Triple triple = it.next();
            sink.send((Object)triple);
        }
        sink.flush();
    }

    public static void writeText(OutputStream out, ResultSet rs) {
        ResultSetFormatter.outputAsTSV((OutputStream)out, (ResultSet)rs);
    }

    public static String formatJson(Object o) {
        return (String)MultiMethod.invokeStatic(HttpSparqlEndpoint.class, (String)"_formatJson", (Object[])new Object[]{o});
    }

    public static String _formatJson(Boolean value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SparqlFormatterUtils.writeJson((OutputStream)out, value);
        return out.toString();
    }

    public static String _formatJson(Model model) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SparqlFormatterUtils.writeJson((OutputStream)out, model);
        return out.toString();
    }

    public static String _formatJson(ResultSet rs) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SparqlFormatterUtils.writeJson((OutputStream)out, rs);
        return out.toString();
    }

    public static String _writeJson(OutputStream out, Object o) {
        return (String)MultiMethod.invokeStatic(HttpSparqlEndpoint.class, (String)"writeJson", (Object[])new Object[]{out, o});
    }

    public static void writeJson(OutputStream out, Boolean value) {
        ResultSetFormatter.outputAsJSON((OutputStream)out, (boolean)value);
    }

    public static void writeJson(OutputStream out, Iterator<Triple> triples) {
        Model model = SparqlFormatterUtils.triplesToModel(triples);
        JSONJenaWriter writer = new JSONJenaWriter();
        writer.write(model, out, null);
    }

    public static void writeJson(OutputStream out, Model model) {
        JSONJenaWriter writer = new JSONJenaWriter();
        writer.write(model, out, null);
    }

    public static void writeJson(OutputStream out, ResultSet rs) {
        ResultSetFormatter.outputAsJSON((OutputStream)out, (ResultSet)rs);
    }

    public static String formatTurtle(Object o) {
        return (String)MultiMethod.invokeStatic(HttpSparqlEndpoint.class, (String)"_formatTurtle", (Object[])new Object[]{o});
    }

    public static String _formatTurtle(Model model) {
        return ModelUtils.toString((Model)model, (String)"TTL");
    }

    public static void writeTurtle(OutputStream out, Iterator<Triple> triples) {
        Model model = SparqlFormatterUtils.triplesToModel(triples);
        SparqlFormatterUtils.writeTurtle(out, model);
    }

    public static void writeTurtle(OutputStream out, Model model) {
        model.write(out, "TTL");
    }
}

