/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.util;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.Map;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sql.exprs2.ExprSqlBridge;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.ExprEvaluator;
import org.aksw.sparqlify.core.algorithms.ExprSqlRewrite;
import org.aksw.sparqlify.core.cast.ExprBindingSubstitutor;
import org.aksw.sparqlify.core.cast.TypedExprTransformer;
import org.aksw.sparqlify.core.interfaces.SqlTranslator;
import org.aksw.sparqlify.core.transformations.RdfTermEliminator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTranslatorImpl2
implements SqlTranslator {
    private static final Logger logger = LoggerFactory.getLogger(SqlTranslatorImpl2.class);
    private ExprBindingSubstitutor exprBindingSubstitutor;
    private RdfTermEliminator rdfTermEliminator;
    private ExprEvaluator exprEvaluator;
    private TypedExprTransformer typedExprTransformer;

    public SqlTranslatorImpl2(ExprBindingSubstitutor exprBindingSubstitutor, RdfTermEliminator rdfTermEliminator, ExprEvaluator exprTransformer, TypedExprTransformer typedExprTransformer) {
        this.exprBindingSubstitutor = exprBindingSubstitutor;
        this.rdfTermEliminator = rdfTermEliminator;
        this.exprEvaluator = exprTransformer;
        this.typedExprTransformer = typedExprTransformer;
    }

    public TypedExprTransformer getTypedExprTransformer() {
        return this.typedExprTransformer;
    }

    @Override
    public ExprSqlRewrite translate(Expr sparqlExpr, Map<Var, Expr> binding, Map<String, TypeToken> typeMap) {
        Expr e1 = binding != null ? this.exprBindingSubstitutor.substitute(sparqlExpr, binding) : sparqlExpr;
        E_RdfTerm e2 = this.rdfTermEliminator._transform(e1);
        Expr e3 = this.exprEvaluator.transform((Expr)e2);
        ExprSqlRewrite e4 = this.typedExprTransformer.rewrite(e3, typeMap);
        return e4;
    }

    public static SqlExpr asSqlExpr(ExprSqlRewrite rewrite) {
        Expr tmp = rewrite.getExpr();
        if (!(tmp instanceof E_RdfTerm)) {
            throw new RuntimeException("Wrong expression type - hould not happen");
        }
        E_RdfTerm rdfTerm = (E_RdfTerm)tmp;
        Expr et = rdfTerm.getLexicalValue();
        if (et.isVariable()) {
            String varName = et.getVarName();
            SqlExpr result = rewrite.getProjection().getNameToExpr().get(varName);
            return result;
        }
        throw new RuntimeException("Could not completely rewrite: " + rewrite + " --- stopped at: " + et);
    }

    public static SqlExpr asSqlExprOld(ExprSqlRewrite rewrite) {
        Expr et = rewrite.getExpr();
        if (et instanceof ExprSqlBridge) {
            ExprSqlBridge bridge = (ExprSqlBridge)et;
            SqlExpr result = bridge.getSqlExpr();
            return result;
        }
        throw new RuntimeException("Could not completely rewrite: " + rewrite + " --- stopped at: " + et);
    }
}

