/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aksw.commons.util.MapReader;
import org.aksw.commons.util.StreamUtils;
import org.aksw.commons.util.jdbc.Schema;
import org.aksw.commons.util.jdbc.SqlUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.limit.QueryExecutionFactoryLimit;
import org.aksw.jena_sparql_api.timeout.QueryExecutionFactoryTimeout;
import org.aksw.sparqlify.config.lang.ConfigParser;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.config.v0_2.bridge.ConfiguratorCandidateSelector;
import org.aksw.sparqlify.config.v0_2.bridge.SchemaProviderDummy;
import org.aksw.sparqlify.config.v0_2.bridge.SchemaProviderImpl;
import org.aksw.sparqlify.config.v0_2.bridge.SyntaxBridge;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.algorithms.CandidateViewSelectorImpl;
import org.aksw.sparqlify.core.algorithms.DatatypeToStringPostgres;
import org.aksw.sparqlify.core.algorithms.ExprDatatypeNorm;
import org.aksw.sparqlify.core.algorithms.ExprEvaluator;
import org.aksw.sparqlify.core.algorithms.MappingOpsImpl;
import org.aksw.sparqlify.core.algorithms.OpMappingRewriterImpl;
import org.aksw.sparqlify.core.algorithms.SparqlSqlStringRewriterImpl;
import org.aksw.sparqlify.core.algorithms.SqlOpSelectBlockCollectorImpl;
import org.aksw.sparqlify.core.algorithms.SqlOpSerializerImpl;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizerImpl;
import org.aksw.sparqlify.core.cast.ExprBindingSubstitutorImpl;
import org.aksw.sparqlify.core.cast.SqlExprSerializerSystem;
import org.aksw.sparqlify.core.cast.SqlLiteralMapperDefault;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.cast.TypedExprTransformerImpl;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.CandidateViewSelector;
import org.aksw.sparqlify.core.interfaces.MappingOps;
import org.aksw.sparqlify.core.interfaces.OpMappingRewriter;
import org.aksw.sparqlify.core.interfaces.SparqlSqlOpRewriter;
import org.aksw.sparqlify.core.interfaces.SparqlSqlOpRewriterImpl;
import org.aksw.sparqlify.core.interfaces.SparqlSqlStringRewriter;
import org.aksw.sparqlify.core.interfaces.SqlOpSerializer;
import org.aksw.sparqlify.core.interfaces.SqlTranslator;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryEx;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryExImpl;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactorySparqlifyDs;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactorySparqlifyExplain;
import org.aksw.sparqlify.core.transformations.RdfTermEliminator;
import org.aksw.sparqlify.core.transformations.RdfTermEliminatorImpl;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.util.ExprRewriteSystem;
import org.aksw.sparqlify.util.SparqlifyCoreInit;
import org.aksw.sparqlify.util.SqlTranslatorImpl2;
import org.aksw.sparqlify.util.ViewDefinitionFactory;
import org.antlr.runtime.RecognitionException;
import org.h2.jdbcx.JdbcDataSource;
import org.slf4j.Logger;

public class SparqlifyUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTestDatabase(DataSource ds) throws SQLException {
        Connection conn = ds.getConnection();
        try {
            SparqlifyUtils.initTestDatabase(conn);
        }
        finally {
            conn.close();
        }
    }

    public static void initTestDatabase(Connection conn) throws SQLException {
        conn.createStatement().executeUpdate("DROP TABLE IF EXISTS \"person_to_dept\";");
        conn.createStatement().executeUpdate("DROP TABLE IF EXISTS \"dept\";");
        conn.createStatement().executeUpdate("DROP TABLE IF EXISTS \"person\";");
        conn.createStatement().executeUpdate("CREATE TABLE \"person\" (\"id\" INT PRIMARY KEY, \"name\" VARCHAR, \"age\" INT)");
        conn.createStatement().executeUpdate("CREATE TABLE \"dept\" (\"id\" INT PRIMARY KEY , \"name\" VARCHAR)");
        conn.createStatement().executeUpdate("CREATE TABLE \"person_to_dept\" (\"person_id\" INT, \"dept_id\" INT, UNIQUE(\"person_id\", \"dept_id\"))");
        conn.createStatement().executeUpdate("INSERT INTO \"person\" VALUES (1, 'Anne', 20)");
        conn.createStatement().executeUpdate("INSERT INTO \"person\" VALUES (2, 'Bob', 22)");
        conn.createStatement().executeUpdate("INSERT INTO \"dept\" VALUES (5, 'Research')");
        conn.createStatement().executeUpdate("INSERT INTO \"dept\" VALUES (6, 'Marketing')");
        conn.createStatement().executeUpdate("INSERT INTO \"person_to_dept\" VALUES (1, 5)");
        conn.createStatement().executeUpdate("INSERT INTO \"person_to_dept\" VALUES (2, 6)");
    }

    public static DataSource createTestDatabase() throws SQLException {
        DataSource ds = SparqlifyUtils.createDefaultDatabase("testdb");
        SparqlifyUtils.initTestDatabase(ds);
        return ds;
    }

    public static DataSource createDefaultDatabase(String name) {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + name + ";MODE=PostgreSQL;DB_CLOSE_DELAY=-1");
        ds.setUser("sa");
        ds.setPassword("sa");
        return ds;
    }

    public static void shutdownH2(DataSource dataSource) throws SQLException {
        Connection conn = dataSource.getConnection();
        conn.createStatement().execute("SHUTDOWN");
    }

    public static DataSource createDefaultDatabase(String name, InputStream in) throws SQLException, IOException {
        String sqlStr = StreamUtils.toString((InputStream)in);
        return SparqlifyUtils.createDefaultDatabase(name, sqlStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource createDefaultDatabase(String name, String sqlStr) throws SQLException {
        DataSource ds = SparqlifyUtils.createDefaultDatabase(name);
        Connection conn = ds.getConnection();
        try {
            conn.createStatement().executeUpdate(sqlStr);
        }
        finally {
            conn.close();
        }
        return ds;
    }

    public static ViewDefinitionFactory createViewDefinitionFactory(Connection conn, Map<String, String> typeAlias) throws IOException {
        TypeSystem typeSystem = SparqlifyCoreInit.createDefaultDatatypeSystem();
        ViewDefinitionFactory result = SparqlifyUtils.createViewDefinitionFactory(conn, typeSystem, typeAlias);
        return result;
    }

    public static ViewDefinitionFactory createViewDefinitionFactory(Connection conn, TypeSystem datatypeSystem, Map<String, String> typeAlias) throws IOException {
        ConfigParser parser = new ConfigParser();
        SchemaProviderImpl schemaProvider = new SchemaProviderImpl(conn, datatypeSystem, typeAlias);
        SyntaxBridge syntaxBridge = new SyntaxBridge(schemaProvider);
        ViewDefinitionFactory result = new ViewDefinitionFactory(parser, syntaxBridge);
        return result;
    }

    public static ViewDefinitionFactory createDummyViewDefinitionFactory(Map<String, String> typeAlias) {
        ConfigParser parser = new ConfigParser();
        TypeSystem typeSystem = SparqlifyCoreInit.createDefaultDatatypeSystem();
        SchemaProviderDummy schemaProvider = new SchemaProviderDummy(typeSystem, typeAlias);
        SyntaxBridge syntaxBridge = new SyntaxBridge(schemaProvider);
        ViewDefinitionFactory result = new ViewDefinitionFactory(parser, syntaxBridge);
        return result;
    }

    @Deprecated
    public static SqlExprSerializerSystem createSerializerSystem(TypeSystem typeSystem) {
        SqlExprSerializerSystem result = SparqlifyCoreInit.createSerializerSystem(typeSystem);
        return result;
    }

    public static SqlTranslator createSqlRewriter() {
        TypeSystem typeSystem = SparqlifyCoreInit.createDefaultDatatypeSystem();
        RdfTermEliminatorImpl rdfTermEliminator = SparqlifyCoreInit.createDefaultTransformer(typeSystem);
        ExprEvaluator exprTransformer = SqlTranslationUtils.createDefaultEvaluator();
        SqlTranslator result = SparqlifyUtils.createSqlRewriter(typeSystem, rdfTermEliminator, exprTransformer);
        return result;
    }

    public static SqlTranslator createSqlTranslator(ExprRewriteSystem rewriteSystem) {
        TypeSystem typeSystem = rewriteSystem.getTypeSystem();
        RdfTermEliminator rdfTermEliminator = rewriteSystem.getTermEliminator();
        ExprEvaluator exprTransformer = rewriteSystem.getExprEvaluator();
        ExprBindingSubstitutorImpl exprBindingSubstitutor = new ExprBindingSubstitutorImpl();
        TypedExprTransformerImpl typedExprTransformer = new TypedExprTransformerImpl(typeSystem);
        SqlTranslatorImpl2 result = new SqlTranslatorImpl2(exprBindingSubstitutor, rdfTermEliminator, exprTransformer, typedExprTransformer);
        return result;
    }

    public static SqlTranslator createSqlRewriter(TypeSystem datatypeSystem, RdfTermEliminator rdfTermEliminator, ExprEvaluator exprTransformer) {
        ExprBindingSubstitutorImpl exprBindingSubstitutor = new ExprBindingSubstitutorImpl();
        TypedExprTransformerImpl typedExprTransformer = new TypedExprTransformerImpl(datatypeSystem);
        SqlTranslatorImpl2 result = new SqlTranslatorImpl2(exprBindingSubstitutor, rdfTermEliminator, exprTransformer, typedExprTransformer);
        return result;
    }

    public static Config readConfig(File file) throws IOException, RecognitionException {
        FileInputStream in = new FileInputStream(file);
        return SparqlifyUtils.readConfig(in, null);
    }

    public static Config readConfig(InputStream in) throws IOException, RecognitionException {
        return SparqlifyUtils.readConfig(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config readConfig(InputStream in, Logger logger) throws IOException, RecognitionException {
        ConfigParser parser = new ConfigParser();
        try {
            Config result;
            Config config = result = parser.parse(in, logger);
            return config;
        }
        finally {
            in.close();
        }
    }

    public static Config createConfig(String str, Logger logger) throws IOException, RecognitionException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        Config result = SparqlifyUtils.readConfig(in, logger);
        return result;
    }

    public static List<String> listTables(Connection conn) throws SQLException {
        String query = "SELECT table_name FROM information_schema.tables";
        List result = SqlUtils.executeList((Connection)conn, (String)query, String.class, (Object[])new Object[0]);
        return result;
    }

    public static MappingOps createDefaultMappingOps(ExprRewriteSystem ers) {
        SqlTranslator sqlTranslator = SparqlifyUtils.createSqlRewriter(ers.getTypeSystem(), ers.getTermEliminator(), ers.getExprEvaluator());
        ExprDatatypeNorm exprNormalizer = new ExprDatatypeNorm();
        MappingOpsImpl mappingOps = new MappingOpsImpl(sqlTranslator, exprNormalizer);
        return mappingOps;
    }

    public static OpMappingRewriter createDefaultOpMappingRewriter(ExprRewriteSystem ers) {
        MappingOps mappingOps = SparqlifyUtils.createDefaultMappingOps(ers);
        OpMappingRewriterImpl opMappingRewriter = new OpMappingRewriterImpl(mappingOps);
        return opMappingRewriter;
    }

    public static QueryExecutionFactoryEx createDefaultSparqlifyEngine(DataSource dataSource, Config config, Long maxResultSetSize, Integer maxQueryExecutionTimeInSeconds) throws SQLException, IOException {
        SparqlSqlStringRewriterImpl rewriter = SparqlifyUtils.createDefaultSparqlSqlStringRewriter(dataSource, config, maxResultSetSize, maxQueryExecutionTimeInSeconds);
        SparqlSqlOpRewriter ssoRewriter = rewriter.getSparqlSqlOpRewriter();
        SqlOpSerializer sqlOpSerializer = rewriter.getSqlOpSerializer();
        QueryExecutionFactorySparqlifyDs qefDefault = new QueryExecutionFactorySparqlifyDs(rewriter, dataSource);
        if (maxQueryExecutionTimeInSeconds != null) {
            qefDefault = QueryExecutionFactoryTimeout.decorate((QueryExecutionFactory)qefDefault, (long)(maxQueryExecutionTimeInSeconds * 1000));
        }
        if (maxResultSetSize != null) {
            qefDefault = QueryExecutionFactoryLimit.decorate((QueryExecutionFactory)qefDefault, (boolean)false, (Long)maxResultSetSize);
        }
        QueryExecutionFactorySparqlifyExplain qefExplain = new QueryExecutionFactorySparqlifyExplain(dataSource, ssoRewriter, sqlOpSerializer);
        QueryExecutionFactoryExImpl result = new QueryExecutionFactoryExImpl((QueryExecutionFactory)qefDefault, (QueryExecutionFactory)qefExplain);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SparqlSqlStringRewriterImpl createDefaultSparqlSqlStringRewriter(DataSource dataSource, Config config, Long maxResultSetSize, Integer maxQueryExecutionTime) throws SQLException, IOException {
        Schema databaseSchema;
        CandidateViewSelectorImpl candidateViewSelector;
        RdfViewSystemOld.initSparqlifyFunctions();
        ExprRewriteSystem ers = SparqlifyUtils.createExprRewriteSystem();
        TypeSystem typeSystem = ers.getTypeSystem();
        Map typeAlias = MapReader.readFromResource((String)"/type-map.h2.tsv");
        Connection conn = dataSource.getConnection();
        MappingOps mappingOps = SparqlifyUtils.createDefaultMappingOps(ers);
        OpMappingRewriterImpl opMappingRewriter = new OpMappingRewriterImpl(mappingOps);
        try {
            SchemaProviderImpl schemaProvider = new SchemaProviderImpl(conn, typeSystem, typeAlias);
            SyntaxBridge syntaxBridge = new SyntaxBridge(schemaProvider);
            candidateViewSelector = new CandidateViewSelectorImpl(mappingOps, new ViewDefinitionNormalizerImpl());
            ConfiguratorCandidateSelector.configure(config, syntaxBridge, candidateViewSelector, null);
            databaseSchema = Schema.create((Connection)conn);
        }
        finally {
            conn.close();
        }
        SparqlSqlOpRewriter ssoRewriter = SparqlifyUtils.createSqlOpRewriter(candidateViewSelector, opMappingRewriter, typeSystem, databaseSchema);
        SqlExprSerializerSystem serializerSystem = ers.getSerializerSystem();
        SqlOpSerializerImpl sqlOpSerializer = new SqlOpSerializerImpl(serializerSystem);
        SparqlSqlStringRewriterImpl rewriter = new SparqlSqlStringRewriterImpl(ssoRewriter, sqlOpSerializer);
        return rewriter;
    }

    public static SparqlSqlStringRewriter createSparqlSqlStringRewriter(SparqlSqlOpRewriter ssoRewriter, TypeSystem typeSystem) {
        SqlExprSerializerSystem serializerSystem = SparqlifyUtils.createSerializerSystem(typeSystem);
        SqlOpSerializerImpl sqlOpSerializer = new SqlOpSerializerImpl(serializerSystem);
        SparqlSqlStringRewriterImpl result = new SparqlSqlStringRewriterImpl(ssoRewriter, sqlOpSerializer);
        return result;
    }

    public static SparqlSqlOpRewriter createSqlOpRewriter(CandidateViewSelector<ViewDefinition> candidateViewSelector, OpMappingRewriter opMappingRewriter, TypeSystem datatypeSystem, Schema databaseSchema) throws SQLException, IOException {
        DatatypeToStringPostgres typeSerializer = new DatatypeToStringPostgres();
        SqlLiteralMapperDefault sqlLiteralMapper = new SqlLiteralMapperDefault(typeSerializer);
        SqlOpSelectBlockCollectorImpl collector = new SqlOpSelectBlockCollectorImpl();
        SparqlSqlOpRewriterImpl result = new SparqlSqlOpRewriterImpl(candidateViewSelector, opMappingRewriter, collector, databaseSchema);
        return result;
    }

    @Deprecated
    public static SparqlSqlStringRewriter createTestRewriter(CandidateViewSelector<ViewDefinition> candidateViewSelector, OpMappingRewriter opMappingRewriter, TypeSystem datatypeSystem, Schema databaseSchema) throws SQLException, IOException {
        SparqlSqlOpRewriter ssoRewriter = SparqlifyUtils.createSqlOpRewriter(candidateViewSelector, opMappingRewriter, datatypeSystem, databaseSchema);
        SparqlSqlStringRewriter result = SparqlifyUtils.createSparqlSqlStringRewriter(ssoRewriter, datatypeSystem);
        return result;
    }

    public static Config parseSmlConfig(String str, Logger logger) throws IOException, RecognitionException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        Config result = SparqlifyUtils.parseSmlConfig(in, logger);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config parseSmlConfig(InputStream in, Logger logger) throws IOException, RecognitionException {
        ConfigParser parser = new ConfigParser();
        Config config = null;
        try {
            config = parser.parse(in, logger);
        }
        finally {
            in.close();
        }
        return config;
    }

    public static Node getNode(Binding binding, Var var, Node fallbackNode) {
        Node result = binding.get(var);
        if (result == null) {
            result = fallbackNode;
        }
        return result;
    }

    public static QueryExecutionFactoryExImpl createQueryExecutionFactoryEx(DataSource dataSource, SparqlSqlOpRewriter sparqlSqlOpRewriter, SqlOpSerializer sqlOpSerializer) {
        SparqlSqlStringRewriterImpl sssRewriter = new SparqlSqlStringRewriterImpl(sparqlSqlOpRewriter, sqlOpSerializer);
        QueryExecutionFactorySparqlifyDs qefDefault = new QueryExecutionFactorySparqlifyDs(sssRewriter, dataSource);
        QueryExecutionFactorySparqlifyExplain qefExplain = new QueryExecutionFactorySparqlifyExplain(dataSource, sparqlSqlOpRewriter, sqlOpSerializer);
        QueryExecutionFactoryExImpl result = new QueryExecutionFactoryExImpl((QueryExecutionFactory)qefDefault, (QueryExecutionFactory)qefExplain);
        return result;
    }

    public static ExprRewriteSystem createExprRewriteSystem() {
        RdfViewSystemOld.initSparqlifyFunctions();
        TypeSystem typeSystem = SparqlifyCoreInit.createDefaultDatatypeSystem();
        RdfTermEliminatorImpl exprTransformer = SparqlifyCoreInit.createDefaultTransformer(typeSystem);
        SqlExprSerializerSystem serializerSystem = SparqlifyCoreInit.createSerializerSystem(typeSystem);
        ExprEvaluator exprEvaluator = SqlTranslationUtils.createDefaultEvaluator();
        ExprRewriteSystem result = new ExprRewriteSystem(typeSystem, exprTransformer, exprEvaluator, serializerSystem);
        SparqlifyCoreInit.loadExtensionFunctions(typeSystem, exprTransformer, serializerSystem);
        return result;
    }

    public static SparqlSqlOpRewriterImpl unwrapOpRewriter(QueryExecutionFactory qef) {
        QueryExecutionFactoryExImpl tmp = (QueryExecutionFactoryExImpl)qef.unwrap(QueryExecutionFactoryExImpl.class);
        QueryExecutionFactorySparqlifyDs q = (QueryExecutionFactorySparqlifyDs)((Object)tmp.getDefaultQef().unwrap(QueryExecutionFactorySparqlifyDs.class));
        SparqlSqlStringRewriterImpl sssRewriter = (SparqlSqlStringRewriterImpl)q.getRewriter();
        SparqlSqlOpRewriterImpl result = (SparqlSqlOpRewriterImpl)sssRewriter.getSparqlSqlOpRewriter();
        return result;
    }

    public static SqlTranslator unwrapSqlTransformer(SparqlSqlOpRewriterImpl opRewriter) {
        OpMappingRewriterImpl opMappingRewriter = (OpMappingRewriterImpl)opRewriter.getOpMappingRewriter();
        MappingOpsImpl mappingOps = (MappingOpsImpl)opMappingRewriter.getMappingOps();
        SqlTranslator result = mappingOps.getSqlTranslator();
        return result;
    }

    public static CandidateViewSelectorImpl unwrapCandidateViewSelector(SparqlSqlOpRewriterImpl opRewriter) {
        CandidateViewSelectorImpl result = (CandidateViewSelectorImpl)opRewriter.getCandidateViewSelector();
        return result;
    }
}

