/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.trash;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.core.SqlDatatype;

public class RdfViewDatabase {
    private static Map<String, SqlDatatype> rawTypeToSql = new HashMap<String, SqlDatatype>();
    public static final Pattern explainCostPattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getCostPostgres(Connection conn, String query) throws SQLException {
        String q = "EXPLAIN " + query;
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery(q);
            ResultSetMetaData meta = rs.getMetaData();
            rs.next();
            int i = 0;
            if (i < meta.getColumnCount()) {
                String str = rs.getObject(i + 1).toString();
                Matcher matcher = explainCostPattern.matcher(str);
                matcher.find();
                String maxCostStr = matcher.group(3);
                Double maxCost = Double.parseDouble(maxCostStr);
                double d = maxCost;
                return d;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        throw new RuntimeException("Could not determine cost of the query: " + query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getRawTypes(Connection conn, String queryStr) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        ResultSet rs = conn.createStatement().executeQuery(queryStr);
        try {
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String name = meta.getColumnName(i);
                String typeName = meta.getColumnTypeName(i);
                result.put(name, typeName);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public static SqlDatatype asDatatype(String id) {
        SqlDatatype result = rawTypeToSql.get(id.toLowerCase());
        if (result == null) {
            throw new RuntimeException("Raw SQL datatype '" + id + "' not mapped");
        }
        return result;
    }

    public static Map<String, SqlDatatype> transformRawMap(Map<String, String> map) {
        HashMap<String, SqlDatatype> result = new HashMap<String, SqlDatatype>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            SqlDatatype value = RdfViewDatabase.asDatatype(entry.getValue());
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public static Map<String, SqlDatatype> getTypes(Connection conn, String queryStr) throws Exception {
        Map<String, String> map = RdfViewDatabase.getRawTypes(conn, queryStr);
        Map<String, SqlDatatype> result = RdfViewDatabase.transformRawMap(map);
        return result;
    }

    static {
        rawTypeToSql.put("osmentitytype", DatatypeSystemDefault._STRING);
        rawTypeToSql.put("bool", DatatypeSystemDefault._BOOLEAN);
        rawTypeToSql.put("int2", DatatypeSystemDefault._INTEGER);
        rawTypeToSql.put("int4", DatatypeSystemDefault._INTEGER);
        rawTypeToSql.put("int8", DatatypeSystemDefault._INTEGER);
        rawTypeToSql.put("varchar", DatatypeSystemDefault._STRING);
        rawTypeToSql.put("text", DatatypeSystemDefault._STRING);
        rawTypeToSql.put("bpchar", DatatypeSystemDefault._STRING);
        rawTypeToSql.put("float4", DatatypeSystemDefault._FLOAT);
        rawTypeToSql.put("float8", DatatypeSystemDefault._DOUBLE);
        rawTypeToSql.put("float", DatatypeSystemDefault._DOUBLE);
        rawTypeToSql.put("date", DatatypeSystemDefault._DATE_TIME);
        rawTypeToSql.put("timestamp", DatatypeSystemDefault._DATE_TIME);
        rawTypeToSql.put("geography", DatatypeSystemDefault._GEOGRAPHY);
        rawTypeToSql.put("geometry", DatatypeSystemDefault._GEOMETRY);
        explainCostPattern = Pattern.compile("cost=(\\d+(\\.\\d+)?)\\.\\.(\\d+(\\.\\d+)?)");
    }
}

