/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.trash;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExceptionUtils {
    private static final String INDENT = "\t";
    private static List<String> _suppressedPackages = Lists.newArrayList((Object[])new String[]{"org.h2", "org.hibernate", "$Proxy", "org.junit", "java.lang.reflect.Method", "sun.", "org.eclipse", "junit.framework"});

    public static String getFilteredStackTrace(Throwable t) {
        return ExceptionUtils.getFilteredStackTrace(t, true);
    }

    public static String getFilteredStackTrace(Throwable t, boolean shouldFilter) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ExceptionUtils.writeCleanStackTrace(t, pw, shouldFilter);
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    private static void writeCleanStackTrace(Throwable t, PrintWriter s, boolean wantsFilter) {
        s.print("Exception: ");
        ExceptionUtils.printExceptionChain(t, s);
        HashSet skippedPackages = Sets.newHashSet();
        int skippedLines = 0;
        boolean shouldFilter = wantsFilter && ExceptionUtils.filtersEnabled();
        for (StackTraceElement traceElement : ExceptionUtils.getBottomThrowable(t).getStackTrace()) {
            String forbiddenPackageName = null;
            if (shouldFilter) {
                forbiddenPackageName = ExceptionUtils.tryGetForbiddenPackageName(traceElement);
            }
            if (forbiddenPackageName == null) {
                if (skippedPackages.size() > 0) {
                    s.println(ExceptionUtils.getSkippedPackagesMessage(skippedPackages, skippedLines));
                }
                s.println("\tat " + traceElement);
                skippedPackages.clear();
                skippedLines = 0;
                continue;
            }
            ++skippedLines;
            skippedPackages.add(forbiddenPackageName);
        }
        if (skippedLines > 0) {
            s.println(ExceptionUtils.getSkippedPackagesMessage(skippedPackages, skippedLines));
        }
    }

    private static String getSkippedPackagesMessage(Set<String> skippedPackages, int skippedLines) {
        return INDENT + skippedLines + " line" + (skippedLines == 1 ? "" : "s") + " skipped for " + skippedPackages;
    }

    private static Throwable getBottomThrowable(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private static boolean filtersEnabled() {
        return true;
    }

    private static void printExceptionChain(Throwable t, PrintWriter s) {
        s.println(t);
        if (t.getCause() != null) {
            s.print("Caused by: ");
            ExceptionUtils.printExceptionChain(t.getCause(), s);
        }
    }

    private static String tryGetForbiddenPackageName(StackTraceElement traceElement) {
        String classAndMethod = traceElement.getClassName() + "." + traceElement.getMethodName();
        for (String pkg : _suppressedPackages) {
            if (!classAndMethod.startsWith(pkg)) continue;
            return pkg;
        }
        return null;
    }
}

