/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.NestedSet;

public class NestedNormalForm
extends NestedSet<Clause> {
    private NestedNormalForm parent;
    private Map<Var, Set<Clause>> varToClauses = new HashMap<Var, Set<Clause>>();

    public NestedNormalForm(Set<Clause> clauses) {
        super(clauses, false);
        this.parent = null;
        this.index(this);
    }

    private void index(Set<Clause> clauses) {
        for (Clause clause : clauses) {
            this.index(clause);
        }
    }

    private void index(Clause clause) {
        for (Var var : clause.getVarsMentioned()) {
            Set<Clause> clauses = this.varToClauses.get(var);
            if (clauses == null) {
                clauses = new HashSet<Clause>();
                this.varToClauses.put(var, clauses);
            }
            clauses.add(clause);
        }
    }

    public NestedNormalForm(NestedNormalForm parent, boolean asView) {
        super(parent, asView);
        this.parent = parent;
        if (!asView && parent != null) {
            this.index(this);
        }
    }

    public NestedNormalForm getParent() {
        return this.parent;
    }

    public Set<Clause> getClausesByVar(Var var) {
        Set<Clause> result = this.varToClauses.get(var);
        if (result == null && this.parent != null) {
            return this.parent.getClausesByVar(var);
        }
        return result;
    }

    @Override
    protected void onRemove(Clause clause) {
        for (Var var : clause.getVarsMentioned()) {
            Set<Clause> clauses = this.varToClauses.get(var);
            if (clauses == null) {
                if (this.parent == null || (clauses = this.parent.getClausesByVar(var)) == null || !clauses.contains(clause)) continue;
                clauses = new NestedSet<Clause>(clauses, true);
                this.varToClauses.put(var, clauses);
                clauses.remove(clause);
                continue;
            }
            clauses.remove(clause);
        }
    }

    @Override
    protected void onAdd(Clause clause) {
        for (Var var : clause.getVarsMentioned()) {
            Set<Clause> clauses = this.varToClauses.get(var);
            if (clauses == null && this.parent != null && (clauses = this.parent.getClausesByVar(var)) != null && !clauses.contains(clause)) {
                clauses = new NestedSet<Clause>(clauses, true);
                this.varToClauses.put(var, clauses);
            }
            if (clauses == null) {
                clauses = new HashSet<Clause>();
                this.varToClauses.put(var, clauses);
            }
            clauses.add(clause);
        }
    }
}

