/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import java.util.ArrayList;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.apache.commons.collections15.Transformer;

class XlsRowIterator<T>
extends SinglePrefetchIterator<List<T>> {
    private Sheet sheet;
    private int currentRow;
    private Transformer<Cell, T> cellTransformer;
    private Workbook workbook;

    public XlsRowIterator(Sheet sheet, int startRow, Transformer<Cell, T> cellTransformer, Workbook workbook) {
        this.sheet = sheet;
        this.currentRow = startRow;
        this.cellTransformer = cellTransformer;
        this.workbook = workbook;
    }

    protected List<T> prefetch() throws Exception {
        if (this.currentRow >= this.sheet.getRows()) {
            return (List)this.finish();
        }
        Cell[] tmp = this.sheet.getRow(this.currentRow++);
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (int i = 0; i < tmp.length; ++i) {
            Cell cell = tmp[i];
            Cell value = this.cellTransformer != null ? this.cellTransformer.transform((Object)cell) : cell;
            result.add(value);
        }
        return result;
    }

    public void close() {
        super.close();
        if (this.workbook != null) {
            this.workbook.close();
        }
    }
}

