/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.sparqlify.csv.CsvMapperCliMain;
import org.aksw.sparqlify.csv.TripleIteratorState;

public class TripleIteratorTracking
extends SinglePrefetchIterator<Triple> {
    private Iterator<Triple> it;
    private int totalTripleCount = 0;
    private int tripleGenCount = 0;
    private Map<Var, Integer> varCountMap = new HashMap<Var, Integer>();

    public TripleIteratorTracking(Iterator<Triple> it) {
        this.it = it;
    }

    protected Triple prefetch() throws Exception {
        while (this.it.hasNext()) {
            ++this.totalTripleCount;
            Triple t = this.it.next();
            CsvMapperCliMain.countVariable(t.getSubject(), this.varCountMap);
            CsvMapperCliMain.countVariable(t.getPredicate(), this.varCountMap);
            CsvMapperCliMain.countVariable(t.getObject(), this.varCountMap);
            if (CsvMapperCliMain.containsNullOrVar(t)) continue;
            ++this.tripleGenCount;
            return t;
        }
        return (Triple)this.finish();
    }

    public TripleIteratorState getState() {
        TripleIteratorState result = new TripleIteratorState(this.totalTripleCount, this.tripleGenCount, this.varCountMap);
        return result;
    }
}

