/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.transformations.ExprTransformer;
import org.aksw.sparqlify.core.transformations.RdfTermEliminatorWriteable;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfTermEliminatorImpl
implements RdfTermEliminatorWriteable {
    private static final Logger logger = LoggerFactory.getLogger(RdfTermEliminatorImpl.class);
    private Map<String, ExprTransformer> idToTransformer = new HashMap<String, ExprTransformer>();
    private static Set<Expr> seenErrors = new HashSet<Expr>();

    public RdfTermEliminatorImpl() {
    }

    public RdfTermEliminatorImpl(Map<String, ExprTransformer> idToTransformer) {
        this.idToTransformer = idToTransformer;
    }

    public Map<String, ExprTransformer> getTransformerMap() {
        return this.idToTransformer;
    }

    public ExprTransformer lookup(ExprFunction fn) {
        String id = ExprUtils.getFunctionId(fn);
        ExprTransformer result = this.idToTransformer.get(id);
        return result;
    }

    @Override
    public E_RdfTerm _transform(Expr expr) {
        E_RdfTerm result;
        if (expr.isFunction()) {
            ExprFunction e = expr.getFunction();
            result = this.transform(e);
        } else if (expr.isConstant()) {
            NodeValue e = expr.getConstant();
            result = this.transform(e);
        } else if (expr.isVariable()) {
            ExprVar e = (ExprVar)expr;
            result = this.transform(e);
        } else {
            throw new RuntimeException("Should not happen");
        }
        return result;
    }

    public E_RdfTerm transform(NodeValue expr) {
        E_RdfTerm result = SqlTranslationUtils.expandConstant((Expr)expr);
        return result;
    }

    public E_RdfTerm transform(ExprVar expr) {
        E_RdfTerm result = E_RdfTerm.createVar(expr);
        return result;
    }

    public E_RdfTerm transform(ExprFunction fn) {
        List args = fn.getArgs();
        ArrayList<E_RdfTerm> newArgs = new ArrayList<E_RdfTerm>(args.size());
        for (Expr arg : args) {
            E_RdfTerm newArg = this._transform(arg);
            newArgs.add(newArg);
        }
        ExprTransformer transformer = this.lookup(fn);
        if (transformer == null) {
            throw new RuntimeException("No transformer registered for " + fn);
        }
        E_RdfTerm result = transformer.transform((Expr)fn, newArgs);
        if (result == null) {
            throw new RuntimeException("Transformer " + fn + " returned null - must not happen.");
        }
        return result;
    }

    @Override
    public void register(String functionSymbol, ExprTransformer exprTransformer) {
        this.idToTransformer.put(functionSymbol, exprTransformer);
    }
}

